/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.resharding;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.ShardId;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.resharding.MergeReshardingEvent;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.resharding.ReshardingType;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.resharding.SplitReshardingEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/resharding/ReshardingEvent;", "", "reshardingType", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/resharding/ReshardingType;", "(Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/resharding/ReshardingType;)V", "getReshardingType", "()Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/resharding/ReshardingType;", "Companion", "vertx-kinesis-consumer-orchestra"})
public abstract class ReshardingEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReshardingType reshardingType;

    public ReshardingEvent(@NotNull ReshardingType reshardingType) {
        Intrinsics.checkNotNullParameter((Object)((Object)reshardingType), (String)"reshardingType");
        this.reshardingType = reshardingType;
    }

    @NotNull
    public final ReshardingType getReshardingType() {
        return this.reshardingType;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a8\u0006\t"}, d2={"Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/resharding/ReshardingEvent$Companion;", "", "()V", "create", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/resharding/ReshardingEvent;", "parentShardId", "Lch/sourcemotion/vertx/kinesis/consumer/orchestra/impl/ShardId;", "childShardIds", "", "vertx-kinesis-consumer-orchestra"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReshardingEvent create(@NotNull ShardId parentShardId, @NotNull List<ShardId> childShardIds) {
            ReshardingEvent reshardingEvent;
            Intrinsics.checkNotNullParameter((Object)parentShardId, (String)"parentShardId");
            Intrinsics.checkNotNullParameter(childShardIds, (String)"childShardIds");
            switch (childShardIds.size()) {
                case 1: {
                    reshardingEvent = new MergeReshardingEvent(parentShardId, (ShardId)CollectionsKt.first(childShardIds));
                    break;
                }
                case 2: {
                    reshardingEvent = new SplitReshardingEvent(parentShardId, childShardIds);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unable to create resharding event from a parent with an unexpected count of child shards " + childShardIds.size());
                }
            }
            return reshardingEvent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

