/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.api;

import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.Record;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\n \"*\u0004\u0018\u00010!0!J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006$"}, d2={"Lch/sourcemotion/vertx/kinesis/consumer/orchestra/api/JsonRecord;", "", "sequenceNumber", "", "approximateArrivalTimestamp", "Ljava/time/Instant;", "data", "", "partitionKey", "encryptionType", "Lsoftware/amazon/awssdk/services/kinesis/model/EncryptionType;", "(Ljava/lang/String;Ljava/time/Instant;[BLjava/lang/String;Lsoftware/amazon/awssdk/services/kinesis/model/EncryptionType;)V", "getApproximateArrivalTimestamp", "()Ljava/time/Instant;", "getData", "()[B", "getEncryptionType", "()Lsoftware/amazon/awssdk/services/kinesis/model/EncryptionType;", "getPartitionKey", "()Ljava/lang/String;", "getSequenceNumber", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toAwsRecord", "Lsoftware/amazon/awssdk/services/kinesis/model/Record;", "kotlin.jvm.PlatformType", "toString", "vertx-kinesis-consumer-orchestra"})
public final class JsonRecord {
    @NotNull
    private final String sequenceNumber;
    @NotNull
    private final Instant approximateArrivalTimestamp;
    @NotNull
    private final byte[] data;
    @NotNull
    private final String partitionKey;
    @Nullable
    private final EncryptionType encryptionType;

    public JsonRecord(@NotNull String sequenceNumber, @NotNull Instant approximateArrivalTimestamp, @NotNull byte[] data, @NotNull String partitionKey, @Nullable EncryptionType encryptionType) {
        Intrinsics.checkNotNullParameter((Object)sequenceNumber, (String)"sequenceNumber");
        Intrinsics.checkNotNullParameter((Object)approximateArrivalTimestamp, (String)"approximateArrivalTimestamp");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)partitionKey, (String)"partitionKey");
        this.sequenceNumber = sequenceNumber;
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        this.data = data;
        this.partitionKey = partitionKey;
        this.encryptionType = encryptionType;
    }

    @NotNull
    public final String getSequenceNumber() {
        return this.sequenceNumber;
    }

    @NotNull
    public final Instant getApproximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final String getPartitionKey() {
        return this.partitionKey;
    }

    @Nullable
    public final EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public final Record toAwsRecord() {
        return (Record)Record.builder().sequenceNumber(this.sequenceNumber).approximateArrivalTimestamp(this.approximateArrivalTimestamp).data(SdkBytes.fromByteArray((byte[])this.data)).partitionKey(this.partitionKey).encryptionType(this.encryptionType).build();
    }

    @NotNull
    public final String component1() {
        return this.sequenceNumber;
    }

    @NotNull
    public final Instant component2() {
        return this.approximateArrivalTimestamp;
    }

    @NotNull
    public final byte[] component3() {
        return this.data;
    }

    @NotNull
    public final String component4() {
        return this.partitionKey;
    }

    @Nullable
    public final EncryptionType component5() {
        return this.encryptionType;
    }

    @NotNull
    public final JsonRecord copy(@NotNull String sequenceNumber, @NotNull Instant approximateArrivalTimestamp, @NotNull byte[] data, @NotNull String partitionKey, @Nullable EncryptionType encryptionType) {
        Intrinsics.checkNotNullParameter((Object)sequenceNumber, (String)"sequenceNumber");
        Intrinsics.checkNotNullParameter((Object)approximateArrivalTimestamp, (String)"approximateArrivalTimestamp");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)partitionKey, (String)"partitionKey");
        return new JsonRecord(sequenceNumber, approximateArrivalTimestamp, data, partitionKey, encryptionType);
    }

    public static /* synthetic */ JsonRecord copy$default(JsonRecord jsonRecord, String string, Instant instant, byte[] byArray, String string2, EncryptionType encryptionType, int n, Object object) {
        if ((n & 1) != 0) {
            string = jsonRecord.sequenceNumber;
        }
        if ((n & 2) != 0) {
            instant = jsonRecord.approximateArrivalTimestamp;
        }
        if ((n & 4) != 0) {
            byArray = jsonRecord.data;
        }
        if ((n & 8) != 0) {
            string2 = jsonRecord.partitionKey;
        }
        if ((n & 0x10) != 0) {
            encryptionType = jsonRecord.encryptionType;
        }
        return jsonRecord.copy(string, instant, byArray, string2, encryptionType);
    }

    @NotNull
    public String toString() {
        return "JsonRecord(sequenceNumber=" + this.sequenceNumber + ", approximateArrivalTimestamp=" + this.approximateArrivalTimestamp + ", data=" + Arrays.toString(this.data) + ", partitionKey=" + this.partitionKey + ", encryptionType=" + this.encryptionType + ")";
    }

    public int hashCode() {
        int result = this.sequenceNumber.hashCode();
        result = result * 31 + this.approximateArrivalTimestamp.hashCode();
        result = result * 31 + Arrays.hashCode(this.data);
        result = result * 31 + this.partitionKey.hashCode();
        result = result * 31 + (this.encryptionType == null ? 0 : this.encryptionType.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonRecord)) {
            return false;
        }
        JsonRecord jsonRecord = (JsonRecord)other;
        if (!Intrinsics.areEqual((Object)this.sequenceNumber, (Object)jsonRecord.sequenceNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.approximateArrivalTimestamp, (Object)jsonRecord.approximateArrivalTimestamp)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)jsonRecord.data)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.partitionKey, (Object)jsonRecord.partitionKey)) {
            return false;
        }
        return this.encryptionType == jsonRecord.encryptionType;
    }
}

