/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.internal.service;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.ShardId;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.internal.service.ConsumerControlService;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.internal.service.StopConsumersCmdResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ConsumerControlServiceVertxEBProxy
implements ConsumerControlService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public ConsumerControlServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public ConsumerControlServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options2) {
        this._vertx = vertx;
        this._address = address;
        this._options = options2;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Future<Void> stopConsumer(ShardId shardId) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)(shardId != null ? shardId.toJson() : null));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "stopConsumer");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Void)msg.body());
    }

    @Override
    public Future<StopConsumersCmdResult> stopConsumers(int consumerCount) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("consumerCount", (Object)consumerCount);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "stopConsumers");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> msg.body() != null ? new StopConsumersCmdResult((JsonObject)msg.body()) : null);
    }

    @Override
    public Future<Integer> startConsumers(List<ShardId> shardIds) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("shardIds", (Object)new JsonArray(shardIds == null ? Collections.emptyList() : shardIds.stream().map(v -> v != null ? v.toJson() : null).collect(Collectors.toList())));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "startConsumers");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Integer)msg.body());
    }
}

