/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.spi;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.SequenceNumberIteratorPosition;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.spi.ShardStatePersistenceService;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.List;

public class ShardStatePersistenceServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final ShardStatePersistenceService service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;
    private final boolean includeDebugInfo;

    public ShardStatePersistenceServiceVertxProxyHandler(Vertx vertx, ShardStatePersistenceService service) {
        this(vertx, service, 300L);
    }

    public ShardStatePersistenceServiceVertxProxyHandler(Vertx vertx, ShardStatePersistenceService service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public ShardStatePersistenceServiceVertxProxyHandler(Vertx vertx, ShardStatePersistenceService service, boolean topLevel, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond, false);
    }

    public ShardStatePersistenceServiceVertxProxyHandler(Vertx vertx, ShardStatePersistenceService service, boolean topLevel, long timeoutSeconds, boolean includeDebugInfo) {
        this.vertx = vertx;
        this.service = service;
        this.includeDebugInfo = includeDebugInfo;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "getShardIdsInProgress": {
                    this.service.getShardIdsInProgress(HelperUtils.convertList((List)json.getJsonArray("shardIds").getList()), (Handler<AsyncResult<List<String>>>)HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "flagShardInProgress": {
                    this.service.flagShardInProgress((String)json.getValue("shardId"), (Handler<AsyncResult<Boolean>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "flagShardNoMoreInProgress": {
                    this.service.flagShardNoMoreInProgress((String)json.getValue("shardId"), (Handler<AsyncResult<Boolean>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "saveConsumerShardSequenceNumber": {
                    this.service.saveConsumerShardSequenceNumber((String)json.getValue("shardId"), (String)json.getValue("sequenceNumber"), json.getString("iteratorPosition") == null ? null : SequenceNumberIteratorPosition.valueOf(json.getString("iteratorPosition")), (Handler<AsyncResult<Void>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "getConsumerShardSequenceNumber": {
                    this.service.getConsumerShardSequenceNumber((String)json.getValue("shardId"), (Handler<AsyncResult<JsonObject>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "deleteShardSequenceNumber": {
                    this.service.deleteShardSequenceNumber((String)json.getValue("shardId"), (Handler<AsyncResult<Boolean>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "saveFinishedShard": {
                    this.service.saveFinishedShard((String)json.getValue("shardId"), json.getValue("expirationMillis") == null ? null : Long.valueOf(json.getLong("expirationMillis")), (Handler<AsyncResult<Void>>)HelperUtils.createHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                case "getFinishedShardIds": {
                    this.service.getFinishedShardIds(HelperUtils.convertList((List)json.getJsonArray("shardIds").getList()), (Handler<AsyncResult<List<String>>>)HelperUtils.createListHandler(msg, (boolean)this.includeDebugInfo));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            if (this.includeDebugInfo) {
                msg.reply((Object)new ServiceException(500, t.getMessage(), HelperUtils.generateDebugInfo((Throwable)t)));
            } else {
                msg.reply((Object)new ServiceException(500, t.getMessage()));
            }
            throw t;
        }
    }
}

