/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.internal.service;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.internal.service.NodeScoreDto;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.internal.service.NodeScoreService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.List;
import java.util.stream.Collectors;

public class NodeScoreServiceVertxEBProxy
implements NodeScoreService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public NodeScoreServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public NodeScoreServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options2) {
        this._vertx = vertx;
        this._address = address;
        this._options = options2;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Future<Void> setThisNodeScore(int score) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("score", (Object)score);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "setThisNodeScore");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Void)msg.body());
    }

    @Override
    public Future<List<NodeScoreDto>> getNodeScores() {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "getNodeScores");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> ((JsonArray)msg.body()).stream().map(v -> v != null ? new NodeScoreDto((JsonObject)v) : null).collect(Collectors.toList()));
    }
}

