/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.kinesis.consumer.orchestra.spi;

import ch.sourcemotion.vertx.kinesis.consumer.orchestra.impl.SequenceNumberIteratorPosition;
import ch.sourcemotion.vertx.kinesis.consumer.orchestra.spi.ShardStatePersistenceService;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyUtils;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.List;

public class ShardStatePersistenceServiceVertxEBProxy
implements ShardStatePersistenceService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public ShardStatePersistenceServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public ShardStatePersistenceServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options2) {
        this._vertx = vertx;
        this._address = address;
        this._options = options2;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void getShardIdsInProgress(List<String> shardIds, Handler<AsyncResult<List<String>>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardIds", (Object)new JsonArray(shardIds));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "getShardIdsInProgress");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }

    @Override
    public void flagShardInProgress(String shardId, Handler<AsyncResult<Boolean>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)shardId);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "flagShardInProgress");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Boolean)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void flagShardNoMoreInProgress(String shardId, Handler<AsyncResult<Boolean>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)shardId);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "flagShardNoMoreInProgress");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Boolean)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void saveConsumerShardSequenceNumber(String shardId, String sequenceNumber, SequenceNumberIteratorPosition iteratorPosition, Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)shardId);
        _json.put("sequenceNumber", (Object)sequenceNumber);
        _json.put("iteratorPosition", (Object)(iteratorPosition == null ? null : iteratorPosition.name()));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "saveConsumerShardSequenceNumber");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Void)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void getConsumerShardSequenceNumber(String shardId, Handler<AsyncResult<JsonObject>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)shardId);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "getConsumerShardSequenceNumber");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((JsonObject)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void deleteShardSequenceNumber(String shardId, Handler<AsyncResult<Boolean>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)shardId);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "deleteShardSequenceNumber");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Boolean)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void saveFinishedShard(String shardId, long expirationMillis, Handler<AsyncResult<Void>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardId", (Object)shardId);
        _json.put("expirationMillis", (Object)expirationMillis);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "saveFinishedShard");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Void)((Message)res.result()).body())));
            }
        });
    }

    @Override
    public void getFinishedShardIds(List<String> shardIds, Handler<AsyncResult<List<String>>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return;
        }
        JsonObject _json = new JsonObject();
        _json.put("shardIds", (Object)new JsonArray(shardIds));
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "getFinishedShardIds");
        this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)ProxyUtils.convertList((List)((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
    }
}

