/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall;

import ch.sourcemotion.vertx.redis.client.heimdall.PendingCommand;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdall;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallLight;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.PostReconnectJob;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.RedisHeimdallImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayDeque;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00140\u00180\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00180\u0017H\u0016J$\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00180\u0017H\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0002J\u0014\u0010#\u001a\u00020\u001b2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J$\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallLight;", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdall;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/PostReconnectJob;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;)V", "connection", "Lio/vertx/redis/client/RedisConnection;", "pendingStartCommands", "Ljava/util/ArrayDeque;", "Lch/sourcemotion/vertx/redis/client/heimdall/PendingCommand;", "redisHeimdall", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/RedisHeimdallImpl;", "started", "", "batch", "Lio/vertx/redis/client/Redis;", "commands", "", "Lio/vertx/redis/client/Request;", "onSend", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/redis/client/Response;", "close", "", "connect", "handler", "execute", "redis", "executePendingStartCommands", "getConnection", "Lio/vertx/core/Future;", "handleIfConnectionIssue", "commandResult", "mayStart", "send", "command", "vertx-redis-client-heimdall"})
public final class RedisHeimdallLight
implements RedisHeimdall,
PostReconnectJob {
    private RedisHeimdallImpl redisHeimdall;
    private boolean started;
    private RedisConnection connection;
    private final ArrayDeque<PendingCommand> pendingStartCommands;

    @NotNull
    public Redis send(@NotNull Request command, @NotNull Handler<AsyncResult<Response>> onSend) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(onSend, (String)"onSend");
        RedisConnection conn = this.connection;
        if (conn != null) {
            conn.send(command, (Handler)new Handler<AsyncResult<Response>>(this, onSend){
                final /* synthetic */ RedisHeimdallLight this$0;
                final /* synthetic */ Handler $onSend;

                public final void handle(AsyncResult<Response> result) {
                    AsyncResult<Response> asyncResult = result;
                    Intrinsics.checkNotNullExpressionValue(asyncResult, (String)"result");
                    RedisHeimdallLight.access$handleIfConnectionIssue(this.this$0, asyncResult);
                    this.$onSend.handle(result);
                }
                {
                    this.this$0 = redisHeimdallLight;
                    this.$onSend = handler;
                }
            });
        } else if (!this.started) {
            this.pendingStartCommands.add(new PendingCommand(this, command, onSend){
                final /* synthetic */ RedisHeimdallLight this$0;
                final /* synthetic */ Request $command;
                final /* synthetic */ Handler $onSend;

                public final void execute(@NotNull RedisConnection it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.send(this.$command, (Handler)new Handler<AsyncResult<Response>>(this){
                        final /* synthetic */ send.2 this$0;

                        public final void handle(AsyncResult<Response> result) {
                            RedisHeimdallLight redisHeimdallLight = this.this$0.this$0;
                            AsyncResult<Response> asyncResult = result;
                            Intrinsics.checkNotNullExpressionValue(asyncResult, (String)"result");
                            RedisHeimdallLight.access$handleIfConnectionIssue(redisHeimdallLight, asyncResult);
                            this.this$0.$onSend.handle(result);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = redisHeimdallLight;
                    this.$command = request;
                    this.$onSend = handler;
                }
            });
        } else if (this.redisHeimdall.getReconnectingInProgress()) {
            onSend.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, null, null, 6, null)));
        } else {
            onSend.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, null, 6, null)));
        }
        return this;
    }

    @NotNull
    public Redis batch(@NotNull List<? extends Request> commands, @NotNull Handler<AsyncResult<List<Response>>> onSend) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter(onSend, (String)"onSend");
        RedisConnection conn = this.connection;
        if (conn != null) {
            conn.batch(commands, (Handler)new Handler<AsyncResult<List<Response>>>(this, onSend){
                final /* synthetic */ RedisHeimdallLight this$0;
                final /* synthetic */ Handler $onSend;

                public final void handle(AsyncResult<List<Response>> result) {
                    AsyncResult<List<Response>> asyncResult = result;
                    Intrinsics.checkNotNullExpressionValue(asyncResult, (String)"result");
                    RedisHeimdallLight.access$handleIfConnectionIssue(this.this$0, asyncResult);
                    this.$onSend.handle(result);
                }
                {
                    this.this$0 = redisHeimdallLight;
                    this.$onSend = handler;
                }
            });
        } else if (!this.started) {
            this.pendingStartCommands.add(new PendingCommand(this, commands, onSend){
                final /* synthetic */ RedisHeimdallLight this$0;
                final /* synthetic */ List $commands;
                final /* synthetic */ Handler $onSend;

                public final void execute(@NotNull RedisConnection it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.batch(this.$commands, (Handler)new Handler<AsyncResult<List<Response>>>(this){
                        final /* synthetic */ batch.2 this$0;

                        public final void handle(AsyncResult<List<Response>> result) {
                            RedisHeimdallLight redisHeimdallLight = this.this$0.this$0;
                            AsyncResult<List<Response>> asyncResult = result;
                            Intrinsics.checkNotNullExpressionValue(asyncResult, (String)"result");
                            RedisHeimdallLight.access$handleIfConnectionIssue(redisHeimdallLight, asyncResult);
                            this.this$0.$onSend.handle(result);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = redisHeimdallLight;
                    this.$commands = list;
                    this.$onSend = handler;
                }
            });
        } else if (this.redisHeimdall.getReconnectingInProgress()) {
            onSend.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, null, null, 6, null)));
        } else {
            onSend.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, null, 6, null)));
        }
        return this;
    }

    @NotNull
    public Redis connect(@NotNull Handler<AsyncResult<RedisConnection>> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        RedisConnection conn = this.connection;
        if (conn != null) {
            handler.handle((Object)Future.succeededFuture((Object)conn));
        } else if (!this.started) {
            this.pendingStartCommands.add(new PendingCommand(handler, conn){
                final /* synthetic */ Handler $handler;
                final /* synthetic */ RedisConnection $conn;

                public final void execute(@NotNull RedisConnection it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$handler.handle((Object)Future.succeededFuture((Object)this.$conn));
                }
                {
                    this.$handler = handler;
                    this.$conn = redisConnection;
                }
            });
        } else if (this.redisHeimdall.getReconnectingInProgress()) {
            handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, null, null, 6, null)));
        } else {
            handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, null, 6, null)));
        }
        return this;
    }

    private final void handleIfConnectionIssue(AsyncResult<?> commandResult) {
        Throwable cause;
        if (commandResult.failed() && (cause = commandResult.cause()) instanceof RedisHeimdallException && ((RedisHeimdallException)cause).getReason() == RedisHeimdallException.Reason.CONNECTION_ISSUE) {
            RedisConnection redisConnection = this.connection;
            if (redisConnection != null) {
                redisConnection.close();
            }
            this.connection = null;
        }
    }

    @Override
    public void execute(@NotNull Redis redis, @NotNull Handler<AsyncResult<Unit>> handler) {
        Intrinsics.checkNotNullParameter((Object)redis, (String)"redis");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.getConnection().onSuccess((Handler)new Handler<RedisConnection>(this, handler){
            final /* synthetic */ RedisHeimdallLight this$0;
            final /* synthetic */ Handler $handler;

            public final void handle(RedisConnection it) {
                RedisHeimdallLight.access$setConnection$p(this.this$0, it);
                RedisHeimdallLight.access$mayStart(this.this$0, it).onComplete(this.$handler);
            }
            {
                this.this$0 = redisHeimdallLight;
                this.$handler = handler;
            }
        }).onFailure((Handler)new Handler<Throwable>(handler){
            final /* synthetic */ Handler $handler;

            public final void handle(Throwable it) {
                this.$handler.handle((Object)Future.failedFuture((Throwable)it));
            }
            {
                this.$handler = handler;
            }
        });
    }

    private final Future<RedisConnection> getConnection() {
        Promise p = Promise.promise();
        if (this.connection != null) {
            p.complete((Object)this.connection);
        } else {
            this.redisHeimdall.connect((Handler<AsyncResult<RedisConnection>>)((Handler)new Handler<AsyncResult<RedisConnection>>(p){
                final /* synthetic */ Promise $p;

                public final void handle(AsyncResult<RedisConnection> result) {
                    if (result.succeeded()) {
                        this.$p.complete(result.result());
                    } else {
                        this.$p.fail(result.cause());
                    }
                }
                {
                    this.$p = promise;
                }
            }));
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    private final Future<Unit> mayStart(RedisConnection connection2) {
        Promise p = Promise.promise();
        if (this.started) {
            p.complete();
        } else if (connection2 != null) {
            Object object;
            RedisHeimdallLight redisHeimdallLight = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                RedisHeimdallLight $this$runCatching = redisHeimdallLight;
                boolean bl2 = false;
                $this$runCatching.executePendingStartCommands(connection2);
                $this$runCatching = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)$this$runCatching);
            }
            catch (Throwable $this$runCatching) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
            }
            redisHeimdallLight = object;
            bl = false;
            boolean bl4 = false;
            if (Result.isSuccess-impl((Object)redisHeimdallLight)) {
                Unit it = (Unit)redisHeimdallLight;
                boolean bl5 = false;
                p.complete();
            }
            bl = false;
            bl4 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)redisHeimdallLight);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl6 = false;
                boolean bl7 = false;
                Throwable throwable3 = throwable2;
                boolean bl8 = false;
                Throwable it = throwable3;
                boolean bl9 = false;
                p.fail(it);
            }
        } else {
            this.getConnection().onSuccess((Handler)new Handler<RedisConnection>(this, p){
                final /* synthetic */ RedisHeimdallLight this$0;
                final /* synthetic */ Promise $p;

                public final void handle(RedisConnection conn) {
                    RedisConnection redisConnection = conn;
                    Intrinsics.checkNotNullExpressionValue((Object)redisConnection, (String)"conn");
                    RedisHeimdallLight.access$executePendingStartCommands(this.this$0, redisConnection);
                    RedisHeimdallLight.access$setConnection$p(this.this$0, conn);
                    RedisHeimdallLight.access$setStarted$p(this.this$0, true);
                    this.$p.complete();
                }
                {
                    this.this$0 = redisHeimdallLight;
                    this.$p = promise;
                }
            });
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    static /* synthetic */ Future mayStart$default(RedisHeimdallLight redisHeimdallLight, RedisConnection redisConnection, int n, Object object) {
        if ((n & 1) != 0) {
            redisConnection = null;
        }
        return redisHeimdallLight.mayStart(redisConnection);
    }

    private final void executePendingStartCommands(RedisConnection connection2) {
        if (!this.started) {
            PendingCommand pendingCommand = this.pendingStartCommands.poll();
            while (pendingCommand != null) {
                pendingCommand.execute(connection2);
                pendingCommand = this.pendingStartCommands.poll();
            }
            this.started = true;
        }
    }

    @Override
    public void close() {
        RedisConnection redisConnection = this.connection;
        if (redisConnection != null) {
            redisConnection.close();
        }
        this.redisHeimdall.close();
    }

    public RedisHeimdallLight(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.redisHeimdall = new RedisHeimdallImpl(vertx, options, CollectionsKt.listOf((Object)this));
        this.pendingStartCommands = new ArrayDeque();
        RedisHeimdallLight.mayStart$default(this, null, 1, null);
    }

    public static final /* synthetic */ void access$handleIfConnectionIssue(RedisHeimdallLight $this, AsyncResult commandResult) {
        $this.handleIfConnectionIssue(commandResult);
    }

    public static final /* synthetic */ RedisConnection access$getConnection$p(RedisHeimdallLight $this) {
        return $this.connection;
    }

    public static final /* synthetic */ void access$setConnection$p(RedisHeimdallLight $this, RedisConnection redisConnection) {
        $this.connection = redisConnection;
    }

    public static final /* synthetic */ Future access$mayStart(RedisHeimdallLight $this, RedisConnection connection2) {
        return $this.mayStart(connection2);
    }

    public static final /* synthetic */ void access$executePendingStartCommands(RedisHeimdallLight $this, RedisConnection connection2) {
        $this.executePendingStartCommands(connection2);
    }

    public static final /* synthetic */ boolean access$getStarted$p(RedisHeimdallLight $this) {
        return $this.started;
    }

    public static final /* synthetic */ void access$setStarted$p(RedisHeimdallLight $this, boolean bl) {
        $this.started = bl;
    }
}

