/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdall;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.PostReconnectJob;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.RedisHeimdallImpl;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.RedisHeimdallImpl$sam$io_vertx_core_Handler$0;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.connection.RedisHeimdallConnection;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.DefaultRedisReconnectProcess;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.NoopRedisReconnectProcess;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.RedisReconnectProcess;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u001c\u0010 \u001a\u00020\u00112\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0\"H\u0016J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\"H\u0014J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020)H\u0002J\b\u0010.\u001a\u00020\u001dH\u0002J\u001c\u0010/\u001a\u00020\u000b2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0\"H\u0004R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/RedisHeimdallImpl;", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdall;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "postReconnectJobs", "", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/PostReconnectJob;", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;Ljava/util/List;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "delegate", "Lio/vertx/redis/client/Redis;", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "reconnectingHandler", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/RedisReconnectProcess;", "<set-?>", "reconnectingInProgress", "getReconnectingInProgress", "getVertx", "()Lio/vertx/core/Vertx;", "cleanupBeforeReconnecting", "", "close", "configureRedisConnectionFailureHandler", "connect", "handler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/redis/client/RedisConnection;", "getConnectionImplementation", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/connection/RedisHeimdallConnection;", "delegateConnection", "connectionIssueHandler", "", "handleConnectionFailure", "cause", "sendReconnectingFailedEvent", "sendReconnectingStartEvent", "sendReconnectingSucceededEvent", "skipConnectBecauseReconnecting", "vertx-redis-client-heimdall"})
public class RedisHeimdallImpl
implements RedisHeimdall {
    private final Logger logger;
    private boolean closed;
    private Redis delegate;
    private boolean reconnectingInProgress;
    private final RedisReconnectProcess reconnectingHandler;
    @NotNull
    private final Vertx vertx;
    private final RedisHeimdallOptions options;
    private final List<PostReconnectJob> postReconnectJobs;

    protected final boolean getClosed() {
        return this.closed;
    }

    protected final void setClosed(boolean bl) {
        this.closed = bl;
    }

    public final boolean getReconnectingInProgress() {
        return this.reconnectingInProgress;
    }

    protected final boolean skipConnectBecauseReconnecting(@NotNull Handler<AsyncResult<RedisConnection>> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.reconnectingInProgress) {
            handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, "Client is in reconnection process", null, 4, null)));
        }
        return this.reconnectingInProgress;
    }

    @NotNull
    public Redis connect(@NotNull Handler<AsyncResult<RedisConnection>> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.skipConnectBecauseReconnecting(handler)) {
            return this;
        }
        this.delegate.connect((Handler)new Handler<AsyncResult<RedisConnection>>(this, handler){
            final /* synthetic */ RedisHeimdallImpl this$0;
            final /* synthetic */ Handler $handler;

            public final void handle(AsyncResult<RedisConnection> asyncConnection) {
                if (asyncConnection.succeeded()) {
                    Object object = asyncConnection.result();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"asyncConnection.result()");
                    Function1 function1 = (Function1)new Function1<Throwable, Unit>(this.this$0){

                        public final void invoke(@NotNull Throwable p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            RedisHeimdallImpl.access$handleConnectionFailure((RedisHeimdallImpl)this.receiver, p1);
                        }
                    };
                    RedisHeimdallConnection connection2 = this.this$0.getConnectionImplementation((RedisConnection)object, (Handler<Throwable>)((Handler)new RedisHeimdallImpl$sam$io_vertx_core_Handler$0(function1))).initConnection();
                    this.$handler.handle((Object)Future.succeededFuture((Object)connection2));
                } else {
                    Throwable cause = asyncConnection.cause();
                    if (cause instanceof ConnectionPoolTooBusyException) {
                        this.$handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CLIENT_BUSY, "Too many commands to Redis at once, please use a rate limiting or increase RedisOptions.maxPoolSize", asyncConnection.cause())));
                    } else {
                        Throwable throwable = asyncConnection.cause();
                        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"asyncConnection.cause()");
                        RedisHeimdallImpl.access$handleConnectionFailure(this.this$0, throwable);
                        this.$handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, asyncConnection.cause(), 2, null)));
                    }
                }
            }
            {
                this.this$0 = redisHeimdallImpl;
                this.$handler = handler;
            }
        });
        return this;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.delegate.close();
        }
    }

    private final void handleConnectionFailure(Throwable cause) {
        if (this.closed) {
            return;
        }
        if (this.reconnectingInProgress) {
            this.logger.trace((Object)("Avoid multiple reconnect processes for Redis client to server(s) " + this.options.endpointsToString()));
            return;
        }
        this.reconnectingInProgress = true;
        String logMsg = "Connection(s) to Redis server(s) " + this.options.endpointsToString() + " lost. Start to reconnect against provided configuration.";
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            this.logger.warn((Object)logMsg, cause);
        } else {
            this.logger.warn((Object)logMsg);
        }
        this.cleanupBeforeReconnecting();
        this.sendReconnectingStartEvent(cause);
        this.reconnectingHandler.startReconnectProcess(cause, (Handler<AsyncResult<Redis>>)((Handler)new Handler<AsyncResult<Redis>>(this, cause){
            final /* synthetic */ RedisHeimdallImpl this$0;
            final /* synthetic */ Throwable $cause;

            /*
             * WARNING - void declaration
             */
            public final void handle(AsyncResult<Redis> asyncReconnected) {
                if (asyncReconnected.succeeded()) {
                    void $this$mapTo$iv$iv;
                    Object $this$runCatching2;
                    Object object;
                    RedisHeimdallImpl redisHeimdallImpl = this.this$0;
                    boolean bl = false;
                    try {
                        object = Result.Companion;
                        $this$runCatching2 = redisHeimdallImpl;
                        boolean bl2 = false;
                        RedisHeimdallImpl.access$getDelegate$p((RedisHeimdallImpl)$this$runCatching2).close();
                        $this$runCatching2 = Unit.INSTANCE;
                        bl2 = false;
                        object = Result.constructor-impl((Object)$this$runCatching2);
                    }
                    catch (Throwable $this$runCatching2) {
                        Result.Companion bl2 = Result.Companion;
                        boolean bl3 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
                    }
                    Object object2 = asyncReconnected.result();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"asyncReconnected.result()");
                    RedisHeimdallImpl.access$setDelegate$p(this.this$0, (Redis)object2);
                    RedisHeimdallImpl.access$setReconnectingInProgress$p(this.this$0, false);
                    Iterable $this$map$iv = RedisHeimdallImpl.access$getPostReconnectJobs$p(this.this$0);
                    boolean $i$f$map = false;
                    $this$runCatching2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void job;
                        PostReconnectJob postReconnectJob = (PostReconnectJob)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        Future future = Future.future((Handler)((Handler)new Handler<Promise<Unit>>((PostReconnectJob)job, this){
                            final /* synthetic */ PostReconnectJob $job;
                            final /* synthetic */ handleConnectionFailure.1 this$0;
                            {
                                this.$job = postReconnectJob;
                                this.this$0 = var2_2;
                            }

                            public final void handle(Promise<Unit> it) {
                                Redis redis = this.this$0.this$0;
                                Promise<Unit> promise = it;
                                Intrinsics.checkNotNullExpressionValue(promise, (String)"it");
                                this.$job.execute(redis, (Handler<AsyncResult<Unit>>)((Handler)promise));
                            }
                        }));
                        collection.add(future);
                    }
                    List jobs = (List)destination$iv$iv;
                    CompositeFuture jobsResult = CompositeFuture.all((List)jobs);
                    jobsResult.onFailure((Handler)new Handler<Throwable>(this){
                        final /* synthetic */ handleConnectionFailure.1 this$0;

                        public final void handle(Throwable it) {
                            RedisHeimdallImpl.access$getLogger$p(this.this$0.this$0).warn((Object)"At least one post reconnect job did fail. So we re-initiate reconnection process");
                            RedisHeimdallImpl.access$handleConnectionFailure(this.this$0.this$0, this.this$0.$cause);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    jobsResult.onSuccess((Handler)new Handler<CompositeFuture>(this){
                        final /* synthetic */ handleConnectionFailure.1 this$0;

                        public final void handle(CompositeFuture it) {
                            RedisHeimdallImpl.access$sendReconnectingSucceededEvent(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    Throwable throwable = asyncReconnected.cause();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"asyncReconnected.cause()");
                    RedisHeimdallImpl.access$sendReconnectingFailedEvent(this.this$0, throwable);
                }
            }
            {
                this.this$0 = redisHeimdallImpl;
                this.$cause = throwable;
            }
        }));
    }

    private final void sendReconnectingStartEvent(Throwable cause) {
        if (this.options.getReconnectingNotifications()) {
            this.vertx.eventBus().send(this.options.getReconnectingStartNotificationAddress(), (Object)ExceptionsKt.stackTraceToString((Throwable)cause));
        }
    }

    private final void sendReconnectingSucceededEvent() {
        if (this.options.getReconnectingNotifications()) {
            this.logger.debug((Object)"Send reconnecting succeeded event");
            this.vertx.eventBus().send(this.options.getReconnectingSucceededNotificationAddress(), null);
        }
    }

    private final void sendReconnectingFailedEvent(Throwable cause) {
        if (this.options.getReconnectingNotifications()) {
            this.vertx.eventBus().send(this.options.getReconnectingFailedNotificationAddress(), (Object)ExceptionsKt.stackTraceToString((Throwable)cause));
        }
    }

    private final RedisReconnectProcess configureRedisConnectionFailureHandler() {
        return this.options.getReconnect() ? (RedisReconnectProcess)new DefaultRedisReconnectProcess(this.vertx, this.options, 0, 0L, 12, null) : (RedisReconnectProcess)new NoopRedisReconnectProcess(this.options);
    }

    @NotNull
    protected RedisHeimdallConnection getConnectionImplementation(@NotNull RedisConnection delegateConnection, @NotNull Handler<Throwable> connectionIssueHandler) {
        Intrinsics.checkNotNullParameter((Object)delegateConnection, (String)"delegateConnection");
        Intrinsics.checkNotNullParameter(connectionIssueHandler, (String)"connectionIssueHandler");
        return new RedisHeimdallConnection(delegateConnection, connectionIssueHandler);
    }

    public void cleanupBeforeReconnecting() {
    }

    @NotNull
    protected final Vertx getVertx() {
        return this.vertx;
    }

    public RedisHeimdallImpl(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options, @NotNull List<? extends PostReconnectJob> postReconnectJobs) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(postReconnectJobs, (String)"postReconnectJobs");
        this.vertx = vertx;
        this.options = options;
        this.postReconnectJobs = postReconnectJobs;
        this.logger = LoggerFactory.getLogger(RedisHeimdallImpl.class);
        Redis redis = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.options.getRedisOptions());
        Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"Redis.createClient(vertx, options.redisOptions)");
        this.delegate = redis;
        this.reconnectingHandler = this.configureRedisConnectionFailureHandler();
        this.vertx.getOrCreateContext().addCloseHook(new Closeable(){

            public final void close(Handler<AsyncResult<Void>> closingHandler) {
                Object object;
                RedisHeimdallImpl redisHeimdallImpl = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    RedisHeimdallImpl $this$runCatching = redisHeimdallImpl;
                    boolean bl2 = false;
                    $this$runCatching.close();
                    $this$runCatching = Unit.INSTANCE;
                    bl2 = false;
                    object = Result.constructor-impl((Object)$this$runCatching);
                }
                catch (Throwable $this$runCatching) {
                    Result.Companion bl2 = Result.Companion;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                }
                redisHeimdallImpl = object;
                bl = false;
                boolean bl4 = false;
                if (Result.isSuccess-impl((Object)redisHeimdallImpl)) {
                    Unit it = (Unit)redisHeimdallImpl;
                    boolean bl5 = false;
                    closingHandler.handle((Object)Future.succeededFuture());
                }
                bl = false;
                bl4 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)redisHeimdallImpl);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl8 = false;
                    Throwable it = throwable3;
                    boolean bl9 = false;
                    closingHandler.handle((Object)Future.failedFuture((Throwable)it));
                }
                RedisHeimdallImpl redisHeimdallImpl2 = redisHeimdallImpl;
            }
        });
    }

    public /* synthetic */ RedisHeimdallImpl(Vertx vertx, RedisHeimdallOptions redisHeimdallOptions, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(vertx, redisHeimdallOptions, list);
    }

    public static final /* synthetic */ void access$handleConnectionFailure(RedisHeimdallImpl $this, Throwable cause) {
        $this.handleConnectionFailure(cause);
    }

    public static final /* synthetic */ Redis access$getDelegate$p(RedisHeimdallImpl $this) {
        return $this.delegate;
    }

    public static final /* synthetic */ void access$setDelegate$p(RedisHeimdallImpl $this, Redis redis) {
        $this.delegate = redis;
    }

    public static final /* synthetic */ boolean access$getReconnectingInProgress$p(RedisHeimdallImpl $this) {
        return $this.reconnectingInProgress;
    }

    public static final /* synthetic */ void access$setReconnectingInProgress$p(RedisHeimdallImpl $this, boolean bl) {
        $this.reconnectingInProgress = bl;
    }

    public static final /* synthetic */ List access$getPostReconnectJobs$p(RedisHeimdallImpl $this) {
        return $this.postReconnectJobs;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RedisHeimdallImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$sendReconnectingSucceededEvent(RedisHeimdallImpl $this) {
        $this.sendReconnectingSucceededEvent();
    }

    public static final /* synthetic */ void access$sendReconnectingFailedEvent(RedisHeimdallImpl $this, Throwable cause) {
        $this.sendReconnectingFailedEvent(cause);
    }
}

