/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.AbstractRedisReconnectProcess;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.DefaultRedisReconnectProcess;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0002J$\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0002J$\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0016J \u0010\u0016\u001a\u00020\f*\u00020\u00172\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/DefaultRedisReconnectProcess;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/AbstractRedisReconnectProcess;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "maxReconnectAttempts", "", "reconnectInterval", "", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;IJ)V", "reconnect", "", "previousAttempts", "handler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/redis/client/Redis;", "scheduleReattempt", "startReconnectProcess", "cause", "", "verifyConnection", "Lio/vertx/redis/client/RedisConnection;", "Companion", "vertx-redis-client-heimdall"})
public final class DefaultRedisReconnectProcess
extends AbstractRedisReconnectProcess {
    private final Vertx vertx;
    private final int maxReconnectAttempts;
    private final long reconnectInterval;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    public void startReconnectProcess(@NotNull Throwable cause, @NotNull Handler<AsyncResult<Redis>> handler) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        DefaultRedisReconnectProcess.reconnect$default(this, 0, handler, 1, null);
    }

    private final void reconnect(int previousAttempts, Handler<AsyncResult<Redis>> handler) {
        int n = this.maxReconnectAttempts;
        if (1 <= n && previousAttempts >= n) {
            logger.warn((Object)("Max attempts to reconnect to Redis server(s) " + this.getOptions().endpointsToString() + " reached. Will skip."));
            this.replyMaxNumberOfAttemptsReached(handler, this.getOptions().getMaxReconnectAttempts());
            return;
        }
        Redis client = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.getOptions().getRedisOptions());
        client.connect((Handler)new Handler<AsyncResult<RedisConnection>>(this, handler, client, previousAttempts){
            final /* synthetic */ DefaultRedisReconnectProcess this$0;
            final /* synthetic */ Handler $handler;
            final /* synthetic */ Redis $client;
            final /* synthetic */ int $previousAttempts;

            public final void handle(AsyncResult<RedisConnection> reconnect2) {
                if (reconnect2.succeeded()) {
                    RedisConnection connection2;
                    RedisConnection redisConnection = connection2 = (RedisConnection)reconnect2.result();
                    Intrinsics.checkNotNullExpressionValue((Object)redisConnection, (String)"connection");
                    DefaultRedisReconnectProcess.access$verifyConnection(this.this$0, redisConnection, (Handler)new Handler<AsyncResult<Unit>>(this, connection2){
                        final /* synthetic */ reconnect.1 this$0;
                        final /* synthetic */ RedisConnection $connection;

                        public final void handle(AsyncResult<Unit> verification) {
                            this.$connection.close();
                            if (verification.succeeded()) {
                                DefaultRedisReconnectProcess.access$getLogger$cp().info((Object)("Redis client reconnected to server(s) " + this.this$0.this$0.getOptions().endpointsToString()));
                                this.this$0.$handler.handle((Object)Future.succeededFuture((Object)this.this$0.$client));
                            } else {
                                DefaultRedisReconnectProcess.access$scheduleReattempt(this.this$0.this$0, this.this$0.$previousAttempts, this.this$0.$handler);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$connection = redisConnection;
                        }
                    });
                } else {
                    DefaultRedisReconnectProcess.access$scheduleReattempt(this.this$0, this.$previousAttempts, this.$handler);
                }
            }
            {
                this.this$0 = defaultRedisReconnectProcess;
                this.$handler = handler;
                this.$client = redis;
                this.$previousAttempts = n;
            }
        });
    }

    static /* synthetic */ void reconnect$default(DefaultRedisReconnectProcess defaultRedisReconnectProcess, int n, Handler handler, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        defaultRedisReconnectProcess.reconnect(n, (Handler<AsyncResult<Redis>>)handler);
    }

    private final void scheduleReattempt(int previousAttempts, Handler<AsyncResult<Redis>> handler) {
        logger.debug((Object)("Unable to reconnect to Redis server(s) " + this.getOptions().endpointsToString() + ". " + "Will retry in " + this.reconnectInterval + " Milliseconds"));
        this.vertx.setTimer(this.reconnectInterval, (Handler)new Handler<Long>(this, previousAttempts, handler){
            final /* synthetic */ DefaultRedisReconnectProcess this$0;
            final /* synthetic */ int $previousAttempts;
            final /* synthetic */ Handler $handler;

            public final void handle(Long it) {
                DefaultRedisReconnectProcess.access$reconnect(this.this$0, this.$previousAttempts + 1, this.$handler);
            }
            {
                this.this$0 = defaultRedisReconnectProcess;
                this.$previousAttempts = n;
                this.$handler = handler;
            }
        });
    }

    private final void verifyConnection(RedisConnection $this$verifyConnection, Handler<AsyncResult<Unit>> handler) {
        $this$verifyConnection.send(Request.cmd((Command)Command.PING), (Handler)new Handler<AsyncResult<Response>>(handler){
            final /* synthetic */ Handler $handler;

            public final void handle(AsyncResult<Response> it) {
                if (it.succeeded() && Intrinsics.areEqual((Object)it.result().toString(), (Object)"PONG")) {
                    this.$handler.handle((Object)Future.succeededFuture());
                } else {
                    this.$handler.handle((Object)Future.failedFuture((Throwable)it.cause()));
                }
            }
            {
                this.$handler = handler;
            }
        });
    }

    public DefaultRedisReconnectProcess(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options, int maxReconnectAttempts, long reconnectInterval) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.vertx = vertx;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.reconnectInterval = reconnectInterval;
    }

    public /* synthetic */ DefaultRedisReconnectProcess(Vertx vertx, RedisHeimdallOptions redisHeimdallOptions, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = redisHeimdallOptions.getMaxReconnectAttempts();
        }
        if ((n2 & 8) != 0) {
            l = redisHeimdallOptions.getReconnectInterval();
        }
        this(vertx, redisHeimdallOptions, n, l);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultRedisReconnectProcess.class);
    }

    public static final /* synthetic */ void access$verifyConnection(DefaultRedisReconnectProcess $this, RedisConnection $this$access_u24verifyConnection, Handler handler) {
        $this.verifyConnection($this$access_u24verifyConnection, (Handler<AsyncResult<Unit>>)handler);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$scheduleReattempt(DefaultRedisReconnectProcess $this, int previousAttempts, Handler handler) {
        $this.scheduleReattempt(previousAttempts, (Handler<AsyncResult<Redis>>)handler);
    }

    public static final /* synthetic */ void access$reconnect(DefaultRedisReconnectProcess $this, int previousAttempts, Handler handler) {
        $this.reconnect(previousAttempts, (Handler<AsyncResult<Redis>>)handler);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/DefaultRedisReconnectProcess$Companion;", "", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "vertx-redis-client-heimdall"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

