/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Response;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u001a.\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\u00060\u0005\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"verifySubscriptionCommandOnly", "", "cmd", "Lio/vertx/redis/client/Command;", "handler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/redis/client/Response;", "verifySubscriptionCommandsOnly", "commands", "", "logWrongConnectionType", "", "Lio/vertx/core/logging/Logger;", "connection", "Lio/vertx/redis/client/RedisConnection;", "vertx-redis-client-heimdall"})
public final class RedisHeimdallSubscriptionImplKt {
    public static final void logWrongConnectionType(@NotNull Logger $this$logWrongConnectionType, @NotNull RedisConnection connection2) {
        Intrinsics.checkNotNullParameter((Object)$this$logWrongConnectionType, (String)"$this$logWrongConnectionType");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        $this$logWrongConnectionType.warn((Object)(connection2.getClass().getName() + " a subscription connection type. This is may a bug, " + "please check your configuration or create an issue on " + "https://github.com/wem/vertx-redis-client-heimdall/issues"));
    }

    public static final boolean verifySubscriptionCommandOnly(@NotNull Command cmd, @NotNull Handler<AsyncResult<Response>> handler) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (!RedisHeimdallSubscriptionConnection.Companion.getSupportedCommands().contains(cmd)) {
            handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.UNSUPPORTED_ACTION, "Command " + cmd + " not supported in subscription mode", null, 4, null)));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static final boolean verifySubscriptionCommandsOnly(@NotNull List<? extends Command> commands, @NotNull Handler<AsyncResult<List<Response>>> handler) {
        boolean bl;
        boolean bl2;
        block5: {
            Intrinsics.checkNotNullParameter(commands, (String)"commands");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            Iterable $this$any$iv = commands;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Command it = (Command)element$iv;
                    boolean bl3 = false;
                    if (!(!RedisHeimdallSubscriptionConnection.Companion.getSupportedCommands().contains(it))) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            handler.handle((Object)Future.failedFuture((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.UNSUPPORTED_ACTION, "At least one Command " + commands + " not supported in subscription mode", null, 4, null)));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }
}

