/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription;

import ch.sourcemotion.vertx.redis.client.heimdall.impl.PostReconnectJob;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.RedisHeimdallSubscriptionImplKt;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000bH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionPostReconnectJob;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/PostReconnectJob;", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "execute", "", "redis", "Lio/vertx/redis/client/Redis;", "handler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "vertx-redis-client-heimdall"})
public final class SubscriptionPostReconnectJob
implements PostReconnectJob {
    private static final Logger logger;
    @NotNull
    public static final SubscriptionPostReconnectJob INSTANCE;

    @Override
    public void execute(@NotNull Redis redis, @NotNull Handler<AsyncResult<Unit>> handler) {
        Intrinsics.checkNotNullParameter((Object)redis, (String)"redis");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        logger.debug((Object)"Execute subscription post reconnect job");
        redis.connect((Handler)new Handler<AsyncResult<RedisConnection>>(handler){
            final /* synthetic */ Handler $handler;

            public final void handle(AsyncResult<RedisConnection> it) {
                if (it.succeeded()) {
                    RedisConnection connection2 = (RedisConnection)it.result();
                    if (connection2 instanceof RedisHeimdallSubscriptionConnection) {
                        ((RedisHeimdallSubscriptionConnection)connection2).subscribeAfterReconnect((Handler<AsyncResult<Unit>>)this.$handler);
                    } else {
                        Logger logger = SubscriptionPostReconnectJob.access$getLogger$p(SubscriptionPostReconnectJob.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                        RedisConnection redisConnection = connection2;
                        Intrinsics.checkNotNullExpressionValue((Object)redisConnection, (String)"connection");
                        RedisHeimdallSubscriptionImplKt.logWrongConnectionType(logger, redisConnection);
                        this.$handler.handle((Object)Future.succeededFuture());
                    }
                } else {
                    SubscriptionPostReconnectJob.access$getLogger$p(SubscriptionPostReconnectJob.INSTANCE).warn((Object)"Connect failed during subscription post reconnect job");
                    this.$handler.handle((Object)Future.failedFuture((Throwable)it.cause()));
                }
            }
            {
                this.$handler = handler;
            }
        });
    }

    private SubscriptionPostReconnectJob() {
    }

    static {
        SubscriptionPostReconnectJob subscriptionPostReconnectJob;
        INSTANCE = subscriptionPostReconnectJob = new SubscriptionPostReconnectJob();
        logger = LoggerFactory.getLogger(SubscriptionPostReconnectJob.class);
    }

    public static final /* synthetic */ Logger access$getLogger$p(SubscriptionPostReconnectJob $this) {
        SubscriptionPostReconnectJob subscriptionPostReconnectJob = $this;
        return logger;
    }
}

