/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.connection.RedisHeimdallConnection;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.RedisHeimdallSubscriptionImplKt;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.SubscriptionStore;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnectionKt;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnectionKt$sam$io_vertx_core_Handler$0;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ0\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\u00110\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J$\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00110\u0005H\u0016J\u001a\u0010\u0019\u001a\u00020\u00132\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00110\u0005J6\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00110\u0005R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/connection/RedisHeimdallSubscriptionConnection;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/connection/RedisHeimdallConnection;", "delegate", "Lio/vertx/redis/client/RedisConnection;", "connectionIssueHandler", "Lio/vertx/core/Handler;", "", "subscriptionStore", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;", "messageHandler", "Lio/vertx/redis/client/Response;", "(Lio/vertx/redis/client/RedisConnection;Lio/vertx/core/Handler;Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;Lio/vertx/core/Handler;)V", "batch", "commands", "", "Lio/vertx/redis/client/Request;", "onSend", "Lio/vertx/core/AsyncResult;", "handleSubscriptionMessage", "", "response", "handler", "initConnection", "send", "command", "subscribeAfterReconnect", "subscribeToChannelsAndPatterns", "channelNames", "", "channelPatterns", "Companion", "vertx-redis-client-heimdall"})
public final class RedisHeimdallSubscriptionConnection
extends RedisHeimdallConnection {
    private final SubscriptionStore subscriptionStore;
    private final Handler<Response> messageHandler;
    private static final Logger logger;
    @NotNull
    private static final List<Command> supportedCommands;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public RedisHeimdallConnection initConnection() {
        super.initConnection();
        Function1 function1 = (Function1)new Function1<Response, Unit>(this){

            public final void invoke(@NotNull Response p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                RedisHeimdallSubscriptionConnection.access$handleSubscriptionMessage((RedisHeimdallSubscriptionConnection)this.receiver, p1);
            }
        };
        super.handler((Handler<Response>)((Handler)new RedisHeimdallSubscriptionConnectionKt$sam$io_vertx_core_Handler$0(function1)));
        return this;
    }

    @Override
    @NotNull
    public RedisConnection handler(@NotNull Handler<Response> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        throw (Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.UNSUPPORTED_ACTION, "In subscription mode, you should not register your own subscription handler, as it's handled by Redis Heimdall.", null, 4, null);
    }

    @Override
    @NotNull
    public RedisConnection send(@NotNull Request command, @NotNull Handler<AsyncResult<Response>> onSend) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(onSend, (String)"onSend");
        Command command2 = command.command();
        Intrinsics.checkNotNullExpressionValue((Object)command2, (String)"command.command()");
        if (RedisHeimdallSubscriptionImplKt.verifySubscriptionCommandOnly(command2, onSend)) {
            super.send(command, onSend);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RedisConnection batch(@NotNull List<? extends Request> commands, @NotNull Handler<AsyncResult<List<Response>>> onSend) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Intrinsics.checkNotNullParameter(onSend, (String)"onSend");
        Iterable $this$map$iv = commands;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Request request = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Command command = it.command();
            collection.add(command);
        }
        if (RedisHeimdallSubscriptionImplKt.verifySubscriptionCommandsOnly((List)destination$iv$iv, onSend)) {
            super.batch(commands, onSend);
        }
        return this;
    }

    public final void subscribeToChannelsAndPatterns(@NotNull List<String> channelNames, @NotNull List<String> channelPatterns, @NotNull Handler<AsyncResult<Unit>> handler) {
        Object promise;
        Intrinsics.checkNotNullParameter(channelNames, (String)"channelNames");
        Intrinsics.checkNotNullParameter(channelPatterns, (String)"channelPatterns");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        ArrayList<Future> commandFutures = new ArrayList<Future>();
        Collection collection = channelNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Request cmd;
            promise = Promise.promise();
            commandFutures.add(promise.future());
            Request request = cmd = Request.cmd((Command)Command.SUBSCRIBE);
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"cmd");
            RedisHeimdallSubscriptionConnectionKt.addToCommandArgs(channelNames, request);
            this.send(cmd, (Handler<AsyncResult<Response>>)((Handler)new Handler<AsyncResult<Response>>(channelNames, (Promise)promise){
                final /* synthetic */ List $channelNames;
                final /* synthetic */ Promise $promise;

                public final void handle(AsyncResult<Response> it) {
                    if (it.succeeded()) {
                        RedisHeimdallSubscriptionConnection.access$getLogger$cp().info((Object)("Channel(s) " + this.$channelNames + " subscribed"));
                        this.$promise.complete();
                    } else {
                        RedisHeimdallSubscriptionConnection.access$getLogger$cp().warn((Object)("Subscription to channel(s) " + this.$channelNames + " failed"));
                        this.$promise.fail(it.cause());
                    }
                }
                {
                    this.$channelNames = list;
                    this.$promise = promise;
                }
            }));
        }
        promise = channelPatterns;
        boolean cmd = false;
        if (!promise.isEmpty()) {
            promise = Promise.promise();
            commandFutures.add(promise.future());
            Request request = cmd = Request.cmd((Command)Command.PSUBSCRIBE);
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"cmd");
            RedisHeimdallSubscriptionConnectionKt.addToCommandArgs(channelPatterns, request);
            this.send(cmd, (Handler<AsyncResult<Response>>)((Handler)new Handler<AsyncResult<Response>>(channelPatterns, (Promise)promise){
                final /* synthetic */ List $channelPatterns;
                final /* synthetic */ Promise $promise;

                public final void handle(AsyncResult<Response> it) {
                    if (it.succeeded()) {
                        RedisHeimdallSubscriptionConnection.access$getLogger$cp().info((Object)("Channel pattern(s) " + this.$channelPatterns + " subscribed"));
                        this.$promise.complete();
                    } else {
                        RedisHeimdallSubscriptionConnection.access$getLogger$cp().warn((Object)("Subscription to channel pattern(s) " + this.$channelPatterns + " failed"));
                        this.$promise.fail(it.cause());
                    }
                }
                {
                    this.$channelPatterns = list;
                    this.$promise = promise;
                }
            }));
        }
        collection = commandFutures;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            CompositeFuture.all((List)CollectionsKt.toList((Iterable)commandFutures)).onSuccess((Handler)new Handler<CompositeFuture>(handler){
                final /* synthetic */ Handler $handler;

                public final void handle(CompositeFuture it) {
                    this.$handler.handle((Object)Future.succeededFuture((Object)Unit.INSTANCE));
                }
                {
                    this.$handler = handler;
                }
            }).onFailure((Handler)new Handler<Throwable>(handler){
                final /* synthetic */ Handler $handler;

                public final void handle(Throwable it) {
                    this.$handler.handle((Object)Future.failedFuture((Throwable)it));
                }
                {
                    this.$handler = handler;
                }
            });
        } else {
            handler.handle((Object)Future.succeededFuture((Object)Unit.INSTANCE));
        }
    }

    public final void subscribeAfterReconnect(@NotNull Handler<AsyncResult<Unit>> handler) {
        Collection<String> collection;
        Collection<String> channelNames;
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Collection<String> collection2 = this.subscriptionStore.subscriptions();
        if (collection2 == null || (collection2 = CollectionsKt.toList((Iterable)collection2)) == null) {
            collection2 = channelNames = CollectionsKt.emptyList();
        }
        if ((collection = this.subscriptionStore.patterns()) == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection<String> patterns = collection;
        this.subscribeToChannelsAndPatterns((List<String>)channelNames, (List<String>)patterns, handler);
    }

    private final void handleSubscriptionMessage(Response response) {
        if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"subscribe")) {
            this.subscriptionStore.addSubscription(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"unsubscribe")) {
            this.subscriptionStore.removeSubscription(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"psubscribe")) {
            this.subscriptionStore.addPattern(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"punsubscribe")) {
            this.subscriptionStore.removePattern(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"message")) {
            this.messageHandler.handle((Object)response);
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"pmessage")) {
            this.messageHandler.handle((Object)response);
        } else {
            logger.warn((Object)("Response / Message type from Redis not supported \"" + response + '\"'));
        }
    }

    public RedisHeimdallSubscriptionConnection(@NotNull RedisConnection delegate, @NotNull Handler<Throwable> connectionIssueHandler, @NotNull SubscriptionStore subscriptionStore, @NotNull Handler<Response> messageHandler) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(connectionIssueHandler, (String)"connectionIssueHandler");
        Intrinsics.checkNotNullParameter((Object)subscriptionStore, (String)"subscriptionStore");
        Intrinsics.checkNotNullParameter(messageHandler, (String)"messageHandler");
        super(delegate, connectionIssueHandler);
        this.subscriptionStore = subscriptionStore;
        this.messageHandler = messageHandler;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(RedisHeimdallSubscriptionConnection.class);
        supportedCommands = CollectionsKt.listOf((Object[])new Command[]{Command.SUBSCRIBE, Command.UNSUBSCRIBE, Command.PSUBSCRIBE, Command.PUNSUBSCRIBE});
    }

    public static final /* synthetic */ void access$handleSubscriptionMessage(RedisHeimdallSubscriptionConnection $this, Response response) {
        $this.handleSubscriptionMessage(response);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/connection/RedisHeimdallSubscriptionConnection$Companion;", "", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "supportedCommands", "", "Lio/vertx/redis/client/Command;", "getSupportedCommands", "()Ljava/util/List;", "vertx-redis-client-heimdall"})
    public static final class Companion {
        @NotNull
        public final List<Command> getSupportedCommands() {
            return supportedCommands;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

