/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.AbstractRedisReconnectProcess;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.DefaultRedisReconnectProcess;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0002J\u001e\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\f*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a0\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/DefaultRedisReconnectProcess;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/AbstractRedisReconnectProcess;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "maxReconnectAttempts", "", "reconnectInterval", "", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;IJ)V", "reconnect", "", "promise", "Lio/vertx/core/Promise;", "Lio/vertx/redis/client/Redis;", "previousAttempts", "scheduleReattempt", "startReconnectProcess", "Lio/vertx/core/Future;", "cause", "", "verifyConnection", "Lio/vertx/redis/client/RedisConnection;", "handler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Companion", "vertx-redis-client-heimdall"})
public final class DefaultRedisReconnectProcess
extends AbstractRedisReconnectProcess {
    private final Vertx vertx;
    private final int maxReconnectAttempts;
    private final long reconnectInterval;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Future<Redis> startReconnectProcess(@NotNull Throwable cause) {
        Promise promise;
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Promise promise2 = promise = Promise.promise();
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"promise");
        DefaultRedisReconnectProcess.reconnect$default(this, promise2, 0, 2, null);
        Future future2 = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"promise.future()");
        return future2;
    }

    private final void reconnect(Promise<Redis> promise, int previousAttempts) {
        int n = this.maxReconnectAttempts;
        if (1 <= n && previousAttempts >= n) {
            logger.warn((Object)("Max attempts to reconnect to Redis server(s) " + this.getOptions().endpointsToString() + " reached. Will skip."));
            promise.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.MAX_ATTEMPTS_REACHED, "Max number of reconnect attempts \"" + this.maxReconnectAttempts + "\" to Redis server(s) " + this.getOptions().endpointsToString(), null, 4, null));
        } else {
            Redis client = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.getOptions().getRedisOptions());
            client.connect().onSuccess((Handler)new Handler<RedisConnection>(this, promise, client, previousAttempts){
                final /* synthetic */ DefaultRedisReconnectProcess this$0;
                final /* synthetic */ Promise $promise;
                final /* synthetic */ Redis $client;
                final /* synthetic */ int $previousAttempts;

                public final void handle(RedisConnection connection) {
                    RedisConnection redisConnection = connection;
                    Intrinsics.checkNotNullExpressionValue((Object)redisConnection, (String)"connection");
                    DefaultRedisReconnectProcess.access$verifyConnection(this.this$0, redisConnection, (Handler)new Handler<AsyncResult<Unit>>(this, connection){
                        final /* synthetic */ reconnect.1 this$0;
                        final /* synthetic */ RedisConnection $connection;

                        public final void handle(AsyncResult<Unit> verification) {
                            this.$connection.close();
                            if (verification.succeeded()) {
                                DefaultRedisReconnectProcess.access$getLogger$cp().info((Object)("Redis client reconnected to server(s) " + this.this$0.this$0.getOptions().endpointsToString()));
                                this.this$0.$promise.complete((Object)this.this$0.$client);
                            } else {
                                DefaultRedisReconnectProcess.access$scheduleReattempt(this.this$0.this$0, this.this$0.$promise, this.this$0.$previousAttempts);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$connection = redisConnection;
                        }
                    });
                }
                {
                    this.this$0 = defaultRedisReconnectProcess;
                    this.$promise = promise;
                    this.$client = redis;
                    this.$previousAttempts = n;
                }
            }).onFailure((Handler)new Handler<Throwable>(this, promise, previousAttempts){
                final /* synthetic */ DefaultRedisReconnectProcess this$0;
                final /* synthetic */ Promise $promise;
                final /* synthetic */ int $previousAttempts;

                public final void handle(Throwable it) {
                    DefaultRedisReconnectProcess.access$scheduleReattempt(this.this$0, this.$promise, this.$previousAttempts);
                }
                {
                    this.this$0 = defaultRedisReconnectProcess;
                    this.$promise = promise;
                    this.$previousAttempts = n;
                }
            });
        }
    }

    static /* synthetic */ void reconnect$default(DefaultRedisReconnectProcess defaultRedisReconnectProcess, Promise promise, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        defaultRedisReconnectProcess.reconnect((Promise<Redis>)promise, n);
    }

    private final void scheduleReattempt(Promise<Redis> promise, int previousAttempts) {
        logger.debug((Object)("Unable to reconnect to Redis server(s) " + this.getOptions().endpointsToString() + ". " + "Will retry in " + this.reconnectInterval + " Milliseconds"));
        this.vertx.setTimer(this.reconnectInterval, (Handler)new Handler<Long>(this, promise, previousAttempts){
            final /* synthetic */ DefaultRedisReconnectProcess this$0;
            final /* synthetic */ Promise $promise;
            final /* synthetic */ int $previousAttempts;

            public final void handle(Long it) {
                DefaultRedisReconnectProcess.access$reconnect(this.this$0, this.$promise, this.$previousAttempts + 1);
            }
            {
                this.this$0 = defaultRedisReconnectProcess;
                this.$promise = promise;
                this.$previousAttempts = n;
            }
        });
    }

    private final void verifyConnection(RedisConnection $this$verifyConnection, Handler<AsyncResult<Unit>> handler) {
        $this$verifyConnection.send(Request.cmd((Command)Command.PING), (Handler)new Handler<AsyncResult<Response>>(handler){
            final /* synthetic */ Handler $handler;

            public final void handle(AsyncResult<Response> it) {
                if (it.succeeded() && Intrinsics.areEqual((Object)it.result().toString(), (Object)"PONG")) {
                    this.$handler.handle((Object)Future.succeededFuture());
                } else {
                    this.$handler.handle((Object)Future.failedFuture((Throwable)it.cause()));
                }
            }
            {
                this.$handler = handler;
            }
        });
    }

    public DefaultRedisReconnectProcess(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options, int maxReconnectAttempts, long reconnectInterval) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.vertx = vertx;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.reconnectInterval = reconnectInterval;
    }

    public /* synthetic */ DefaultRedisReconnectProcess(Vertx vertx, RedisHeimdallOptions redisHeimdallOptions, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = redisHeimdallOptions.getMaxReconnectAttempts();
        }
        if ((n2 & 8) != 0) {
            l = redisHeimdallOptions.getReconnectInterval();
        }
        this(vertx, redisHeimdallOptions, n, l);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultRedisReconnectProcess.class);
    }

    public static final /* synthetic */ void access$verifyConnection(DefaultRedisReconnectProcess $this, RedisConnection $this$access_u24verifyConnection, Handler handler) {
        $this.verifyConnection($this$access_u24verifyConnection, (Handler<AsyncResult<Unit>>)handler);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$scheduleReattempt(DefaultRedisReconnectProcess $this, Promise promise, int previousAttempts) {
        $this.scheduleReattempt((Promise<Redis>)promise, previousAttempts);
    }

    public static final /* synthetic */ void access$reconnect(DefaultRedisReconnectProcess $this, Promise promise, int previousAttempts) {
        $this.reconnect((Promise<Redis>)promise, previousAttempts);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/DefaultRedisReconnectProcess$Companion;", "", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "vertx-redis-client-heimdall"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

