/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.connection.RedisHeimdallConnection;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.RedisHeimdallSubscriptionImplKt;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.SubscriptionStore;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnectionKt;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnectionKt$sam$io_vertx_core_Handler$0;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/connection/RedisHeimdallSubscriptionConnection;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/connection/RedisHeimdallConnection;", "delegate", "Lio/vertx/redis/client/RedisConnection;", "connectionIssueHandler", "Lio/vertx/core/Handler;", "", "subscriptionStore", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;", "messageHandler", "Lio/vertx/redis/client/Response;", "(Lio/vertx/redis/client/RedisConnection;Lio/vertx/core/Handler;Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;Lio/vertx/core/Handler;)V", "batch", "Lio/vertx/core/Future;", "", "commands", "Lio/vertx/redis/client/Request;", "handleSubscriptionMessage", "", "response", "handler", "initConnection", "send", "command", "subscribeAfterReconnect", "subscribeToChannelsAndPatterns", "channelNames", "", "channelPatterns", "Companion", "vertx-redis-client-heimdall"})
public final class RedisHeimdallSubscriptionConnection
extends RedisHeimdallConnection {
    private final SubscriptionStore subscriptionStore;
    private final Handler<Response> messageHandler;
    private static final Logger logger;
    @NotNull
    private static final List<Command> supportedCommands;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public RedisHeimdallConnection initConnection() {
        super.initConnection();
        Function1 function1 = (Function1)new Function1<Response, Unit>(this){

            public final void invoke(@NotNull Response p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                RedisHeimdallSubscriptionConnection.access$handleSubscriptionMessage((RedisHeimdallSubscriptionConnection)this.receiver, p1);
            }
        };
        super.handler((Handler<Response>)((Handler)new RedisHeimdallSubscriptionConnectionKt$sam$io_vertx_core_Handler$0(function1)));
        return this;
    }

    @Override
    @NotNull
    public RedisConnection handler(@NotNull Handler<Response> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        throw (Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.UNSUPPORTED_ACTION, "In subscription mode, you should not register your own subscription handler, as it's handled by Redis Heimdall.", null, 4, null);
    }

    @Override
    @NotNull
    public Future<Response> send(@NotNull Request command) {
        Future future2;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Promise promise = Promise.promise();
        Command command2 = command.command();
        Intrinsics.checkNotNullExpressionValue((Object)command2, (String)"command.command()");
        Promise promise2 = promise;
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"promise");
        if (RedisHeimdallSubscriptionImplKt.verifySubscriptionCommandOnly(command2, (Promise<Response>)promise2)) {
            future2 = super.send(command);
        } else {
            Future future3 = promise.future();
            future2 = future3;
            Intrinsics.checkNotNullExpressionValue((Object)future3, (String)"promise.future()");
        }
        return future2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Future<List<Response>> batch(@NotNull List<? extends Request> commands) {
        Future future2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Promise promise = Promise.promise();
        Iterable $this$map$iv = commands;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Request request = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Command command = it.command();
            collection.add(command);
        }
        List list = (List)destination$iv$iv;
        Promise promise2 = promise;
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"promise");
        if (RedisHeimdallSubscriptionImplKt.verifySubscriptionCommandsOnly(list, (Promise<List<Response>>)promise2)) {
            future2 = super.batch(commands);
        } else {
            Future future3 = promise.future();
            future2 = future3;
            Intrinsics.checkNotNullExpressionValue((Object)future3, (String)"promise.future()");
        }
        return future2;
    }

    @NotNull
    public final Future<Unit> subscribeToChannelsAndPatterns(@NotNull List<String> channelNames, @NotNull List<String> channelPatterns) {
        Object cmd;
        Intrinsics.checkNotNullParameter(channelNames, (String)"channelNames");
        Intrinsics.checkNotNullParameter(channelPatterns, (String)"channelPatterns");
        Promise promise = Promise.promise();
        ArrayList<Future> commandFutures = new ArrayList<Future>();
        Collection collection = channelNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Object object = cmd = Request.cmd((Command)Command.SUBSCRIBE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cmd");
            RedisHeimdallSubscriptionConnectionKt.addToCommandArgs(channelNames, (Request)object);
            Future future2 = this.send((Request)cmd).onSuccess((Handler)new Handler<Response>(channelNames){
                final /* synthetic */ List $channelNames;

                public final void handle(Response it) {
                    RedisHeimdallSubscriptionConnection.access$getLogger$cp().info((Object)("Channel(s) " + this.$channelNames + " subscribed"));
                }
                {
                    this.$channelNames = list;
                }
            }).onFailure((Handler)new Handler<Throwable>(channelNames){
                final /* synthetic */ List $channelNames;

                public final void handle(Throwable it) {
                    RedisHeimdallSubscriptionConnection.access$getLogger$cp().warn((Object)("Subscription to channel(s) " + this.$channelNames + " failed"), it);
                }
                {
                    this.$channelNames = list;
                }
            });
            commandFutures.add(future2);
        }
        cmd = channelPatterns;
        boolean future2 = false;
        if (!cmd.isEmpty()) {
            Object object = cmd = Request.cmd((Command)Command.PSUBSCRIBE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cmd");
            RedisHeimdallSubscriptionConnectionKt.addToCommandArgs(channelPatterns, (Request)object);
            Future future3 = this.send((Request)cmd).onSuccess((Handler)new Handler<Response>(channelPatterns){
                final /* synthetic */ List $channelPatterns;

                public final void handle(Response it) {
                    RedisHeimdallSubscriptionConnection.access$getLogger$cp().info((Object)("Channel pattern(s) " + this.$channelPatterns + " subscribed"));
                }
                {
                    this.$channelPatterns = list;
                }
            }).onFailure((Handler)new Handler<Throwable>(channelPatterns){
                final /* synthetic */ List $channelPatterns;

                public final void handle(Throwable it) {
                    RedisHeimdallSubscriptionConnection.access$getLogger$cp().warn((Object)("Subscription to channel pattern(s) " + this.$channelPatterns + " failed"), it);
                }
                {
                    this.$channelPatterns = list;
                }
            });
            commandFutures.add(future3);
        }
        collection = commandFutures;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            CompositeFuture.all((List)CollectionsKt.toList((Iterable)commandFutures)).onSuccess((Handler)new Handler<CompositeFuture>(promise){
                final /* synthetic */ Promise $promise;

                public final void handle(CompositeFuture it) {
                    this.$promise.complete();
                }
                {
                    this.$promise = promise;
                }
            }).onFailure((Handler)new Handler<Throwable>(promise){
                final /* synthetic */ Promise $promise;

                public final void handle(Throwable it) {
                    this.$promise.fail(it);
                }
                {
                    this.$promise = promise;
                }
            });
        } else {
            promise.complete();
        }
        Future future4 = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future4, (String)"promise.future()");
        return future4;
    }

    @NotNull
    public final Future<Unit> subscribeAfterReconnect() {
        Collection<String> collection;
        Collection<String> channelNames;
        Collection<String> collection2 = this.subscriptionStore.subscriptions();
        if (collection2 == null || (collection2 = CollectionsKt.toList((Iterable)collection2)) == null) {
            collection2 = channelNames = CollectionsKt.emptyList();
        }
        if ((collection = this.subscriptionStore.patterns()) == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection<String> patterns = collection;
        return this.subscribeToChannelsAndPatterns((List<String>)channelNames, (List<String>)patterns);
    }

    private final void handleSubscriptionMessage(Response response) {
        if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"subscribe")) {
            this.subscriptionStore.addSubscription(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"unsubscribe")) {
            this.subscriptionStore.removeSubscription(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"psubscribe")) {
            this.subscriptionStore.addPattern(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"punsubscribe")) {
            this.subscriptionStore.removePattern(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"message")) {
            this.messageHandler.handle((Object)response);
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"pmessage")) {
            this.messageHandler.handle((Object)response);
        } else {
            logger.warn((Object)("Response / Message type from Redis not supported \"" + response + '\"'));
        }
    }

    public RedisHeimdallSubscriptionConnection(@NotNull RedisConnection delegate, @NotNull Handler<Throwable> connectionIssueHandler, @NotNull SubscriptionStore subscriptionStore, @NotNull Handler<Response> messageHandler) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(connectionIssueHandler, (String)"connectionIssueHandler");
        Intrinsics.checkNotNullParameter((Object)subscriptionStore, (String)"subscriptionStore");
        Intrinsics.checkNotNullParameter(messageHandler, (String)"messageHandler");
        super(delegate, connectionIssueHandler);
        this.subscriptionStore = subscriptionStore;
        this.messageHandler = messageHandler;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(RedisHeimdallSubscriptionConnection.class);
        supportedCommands = CollectionsKt.listOf((Object[])new Command[]{Command.SUBSCRIBE, Command.UNSUBSCRIBE, Command.PSUBSCRIBE, Command.PUNSUBSCRIBE});
    }

    public static final /* synthetic */ void access$handleSubscriptionMessage(RedisHeimdallSubscriptionConnection $this, Response response) {
        $this.handleSubscriptionMessage(response);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/connection/RedisHeimdallSubscriptionConnection$Companion;", "", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "supportedCommands", "", "Lio/vertx/redis/client/Command;", "getSupportedCommands", "()Ljava/util/List;", "vertx-redis-client-heimdall"})
    public static final class Companion {
        @NotNull
        public final List<Command> getSupportedCommands() {
            return supportedCommands;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

