/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription;

import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.ClientInstanceId;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.ShareableList;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000eR \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;", "", "delegate", "Lio/vertx/core/shareddata/LocalMap;", "", "", "(Lio/vertx/core/shareddata/LocalMap;)V", "addPattern", "", "channelPattern", "addSubscription", "channelName", "close", "patterns", "", "removePattern", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "removeSubscription", "subscriptions", "Companion", "vertx-redis-client-heimdall"})
public final class SubscriptionStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalMap<String, Set<String>> delegate;
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionStore.class);
    @NotNull
    public static final String CHANNEL_LIST = "redis-heimdall-channel-list";
    @NotNull
    public static final String PATTERN_LIST = "redis-heimdall-pattern-list";

    public SubscriptionStore(@NotNull LocalMap<String, Set<String>> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Nullable
    public final Set<String> subscriptions() {
        return (Set)this.delegate.get((Object)CHANNEL_LIST);
    }

    @Nullable
    public final Set<String> patterns() {
        return (Set)this.delegate.get((Object)PATTERN_LIST);
    }

    public final void addSubscription(@NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Set set = (Set)this.delegate.get((Object)CHANNEL_LIST);
        if (set == null) {
            set = new ShareableList();
        }
        Set subscriptions = set;
        boolean added = subscriptions.add(channelName);
        Map map = (Map)this.delegate;
        String string = CHANNEL_LIST;
        map.put(string, subscriptions);
        if (added) {
            logger.debug((Object)("Subscription channel name \"" + channelName + "\" stored"));
        }
    }

    public final void addPattern(@NotNull String channelPattern) {
        Intrinsics.checkNotNullParameter((Object)channelPattern, (String)"channelPattern");
        Set set = (Set)this.delegate.get((Object)PATTERN_LIST);
        if (set == null) {
            set = new ShareableList();
        }
        Set patterns = set;
        boolean added = patterns.add(channelPattern);
        Map map = (Map)this.delegate;
        String string = PATTERN_LIST;
        map.put(string, patterns);
        if (added) {
            logger.debug((Object)("Subscription channel pattern \"" + channelPattern + "\" stored"));
        }
    }

    @Nullable
    public final Boolean removeSubscription(@NotNull String channelName) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Set set = (Set)this.delegate.get((Object)CHANNEL_LIST);
        Boolean it = bl = set == null ? null : Boolean.valueOf(set.remove(channelName));
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)it, (Object)true)) {
            logger.debug((Object)("Subscription channel \"" + channelName + "\" removed from store"));
        }
        return bl;
    }

    @Nullable
    public final Boolean removePattern(@NotNull String channelPattern) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)channelPattern, (String)"channelPattern");
        Set set = (Set)this.delegate.get((Object)PATTERN_LIST);
        Boolean it = bl = set == null ? null : Boolean.valueOf(set.remove(channelPattern));
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)it, (Object)true)) {
            logger.debug((Object)("Subscription channel pattern \"" + channelPattern + "\" removed from store"));
        }
        return bl;
    }

    public final void close() {
        this.delegate.close();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0010"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore$Companion;", "", "()V", "CHANNEL_LIST", "", "PATTERN_LIST", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "createSubscriptionStore", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;", "Lio/vertx/core/Vertx;", "clientInstanceId", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/ClientInstanceId;", "createSubscriptionStore-LucNqko", "(Lio/vertx/core/Vertx;Ljava/lang/String;)Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;", "vertx-redis-client-heimdall"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SubscriptionStore createSubscriptionStore-LucNqko(@NotNull Vertx $this$createSubscriptionStore_u2dLucNqko, @NotNull String clientInstanceId) {
            Intrinsics.checkNotNullParameter((Object)$this$createSubscriptionStore_u2dLucNqko, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)clientInstanceId, (String)"clientInstanceId");
            LocalMap localMap = $this$createSubscriptionStore_u2dLucNqko.sharedData().getLocalMap(ClientInstanceId.toString-impl(clientInstanceId));
            Intrinsics.checkNotNullExpressionValue((Object)localMap, (String)"this.sharedData().getLocalMap(\"$clientInstanceId\")");
            return new SubscriptionStore((LocalMap<String, Set<String>>)localMap);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

