/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdall;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.PostReconnectJob;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.connection.RedisHeimdallConnection;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.DefaultRedisReconnectProcess;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.NoopRedisReconnectProcess;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.RedisReconnectProcess;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00070\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001dH\u0016J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0014J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020,H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u00100\u001a\u00020 H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u0010.\u001a\u00020,H\u0002J\u0010\u00102\u001a\u00020\"2\u0006\u0010.\u001a\u00020,H\u0002J\b\u00103\u001a\u00020\"H\u0002J\u0016\u00104\u001a\u00020\u000b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020&06H\u0004R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00067"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/RedisHeimdallImpl;", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdall;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "postReconnectJobs", "", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/PostReconnectJob;", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;Ljava/util/List;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "delegate", "Lio/vertx/redis/client/Redis;", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "reconnectingHandler", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/RedisReconnectProcess;", "<set-?>", "reconnectingInProgress", "getReconnectingInProgress", "getVertx", "()Lio/vertx/core/Vertx;", "batch", "Lio/vertx/core/Future;", "Lio/vertx/redis/client/Response;", "commands", "Lio/vertx/redis/client/Request;", "cleanupBeforeReconnecting", "", "close", "configureRedisConnectionFailureHandler", "connect", "Lio/vertx/redis/client/RedisConnection;", "getConnectionImplementation", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/connection/RedisHeimdallConnection;", "delegateConnection", "connectionIssueHandler", "Lio/vertx/core/Handler;", "", "handleConnectionFailure", "cause", "send", "command", "sendReconnectingFailedEvent", "sendReconnectingStartEvent", "sendReconnectingSucceededEvent", "skipConnectBecauseReconnecting", "promise", "Lio/vertx/core/Promise;", "vertx-redis-client-heimdall"})
public class RedisHeimdallImpl
implements RedisHeimdall {
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final RedisHeimdallOptions options;
    @NotNull
    private final List<PostReconnectJob> postReconnectJobs;
    private final Logger logger;
    private boolean closed;
    @NotNull
    private Redis delegate;
    private boolean reconnectingInProgress;
    @NotNull
    private final RedisReconnectProcess reconnectingHandler;

    public RedisHeimdallImpl(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options, @NotNull List<? extends PostReconnectJob> postReconnectJobs) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(postReconnectJobs, (String)"postReconnectJobs");
        this.vertx = vertx;
        this.options = options;
        this.postReconnectJobs = postReconnectJobs;
        this.logger = LoggerFactory.getLogger(RedisHeimdallImpl.class);
        Redis redis = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.options.getRedisOptions());
        Intrinsics.checkNotNullExpressionValue((Object)redis, (String)"createClient(vertx, options.redisOptions)");
        this.delegate = redis;
        this.reconnectingHandler = this.configureRedisConnectionFailureHandler();
        Context ctx = this.vertx.getOrCreateContext();
        if (ctx instanceof ContextInternal) {
            ((ContextInternal)ctx).addCloseHook(arg_0 -> RedisHeimdallImpl._init_$lambda-3(this, arg_0));
        }
    }

    public /* synthetic */ RedisHeimdallImpl(Vertx vertx, RedisHeimdallOptions redisHeimdallOptions, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(vertx, redisHeimdallOptions, list);
    }

    @NotNull
    protected final Vertx getVertx() {
        return this.vertx;
    }

    protected final boolean getClosed() {
        return this.closed;
    }

    protected final void setClosed(boolean bl) {
        this.closed = bl;
    }

    public final boolean getReconnectingInProgress() {
        return this.reconnectingInProgress;
    }

    protected final boolean skipConnectBecauseReconnecting(@NotNull Promise<RedisConnection> promise) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (this.reconnectingInProgress) {
            promise.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, "Client is in reconnection process", null, 4, null));
        }
        return this.reconnectingInProgress;
    }

    @NotNull
    public Future<RedisConnection> connect() {
        Promise promise = Promise.promise();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"promise");
        if (this.skipConnectBecauseReconnecting((Promise<RedisConnection>)promise)) {
            Future future = promise.future();
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
            return future;
        }
        this.delegate.connect().onSuccess(arg_0 -> RedisHeimdallImpl.connect$lambda-4(this, promise, arg_0)).onFailure(arg_0 -> RedisHeimdallImpl.connect$lambda-5(promise, this, arg_0));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    @NotNull
    public Future<Response> send(@NotNull Request command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Promise promise = Promise.promise();
        if (command.command().isPubSub()) {
            promise.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.UNSUPPORTED_ACTION, "Please use Redis Heimdall subscription client for PubSub", null, 4, null));
            Future future = promise.future();
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
            return future;
        }
        this.connect().onSuccess(arg_0 -> RedisHeimdallImpl.send$lambda-8(command, this, promise, arg_0)).onFailure(arg_0 -> RedisHeimdallImpl.send$lambda-9(promise, arg_0));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    @NotNull
    public Future<List<Response>> batch(@NotNull List<? extends Request> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Promise promise = Promise.promise();
        for (Request request : commands) {
            if (!request.command().isPubSub()) continue;
            promise.fail("PubSub command in connection-less batch not allowed");
            Future future = promise.future();
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
            return future;
        }
        this.connect().onSuccess(arg_0 -> RedisHeimdallImpl.batch$lambda-12(commands, this, promise, arg_0)).onFailure(arg_0 -> RedisHeimdallImpl.batch$lambda-13(promise, arg_0));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.delegate.close();
        }
    }

    private final void handleConnectionFailure(Throwable cause) {
        if (this.closed) {
            this.logger.debug((Object)"Already closed client will not reconnect");
            return;
        }
        if (this.reconnectingInProgress) {
            this.logger.trace((Object)("Avoid multiple reconnect processes for Redis client to server(s) " + this.options.endpointsToString()));
            return;
        }
        this.reconnectingInProgress = true;
        String logMsg = "Connection(s) to Redis server(s) " + this.options.endpointsToString() + " lost. Start to reconnect against provided configuration.";
        if (this.logger.isDebugEnabled()) {
            this.logger.warn((Object)logMsg, cause);
        } else {
            this.logger.warn((Object)logMsg);
        }
        this.cleanupBeforeReconnecting();
        this.sendReconnectingStartEvent(cause);
        this.reconnectingHandler.startReconnectProcess(cause).onSuccess(arg_0 -> RedisHeimdallImpl.handleConnectionFailure$lambda-18(this, cause, arg_0)).onFailure(arg_0 -> RedisHeimdallImpl.handleConnectionFailure$lambda-19(this, arg_0));
    }

    private final void sendReconnectingStartEvent(Throwable cause) {
        if (this.options.getReconnectingNotifications()) {
            this.vertx.eventBus().send(this.options.getReconnectingStartNotificationAddress(), (Object)ExceptionsKt.stackTraceToString((Throwable)cause));
        }
    }

    private final void sendReconnectingSucceededEvent() {
        if (this.options.getReconnectingNotifications()) {
            this.logger.debug((Object)"Send reconnecting succeeded event");
            this.vertx.eventBus().send(this.options.getReconnectingSucceededNotificationAddress(), null);
        }
    }

    private final void sendReconnectingFailedEvent(Throwable cause) {
        if (this.options.getReconnectingNotifications()) {
            this.vertx.eventBus().send(this.options.getReconnectingFailedNotificationAddress(), (Object)ExceptionsKt.stackTraceToString((Throwable)cause));
        }
    }

    private final RedisReconnectProcess configureRedisConnectionFailureHandler() {
        return this.options.getReconnect() ? (RedisReconnectProcess)new DefaultRedisReconnectProcess(this.vertx, this.options, 0, 0L, 12, null) : (RedisReconnectProcess)new NoopRedisReconnectProcess(this.options);
    }

    @NotNull
    protected RedisHeimdallConnection getConnectionImplementation(@NotNull RedisConnection delegateConnection, @NotNull Handler<Throwable> connectionIssueHandler) {
        Intrinsics.checkNotNullParameter((Object)delegateConnection, (String)"delegateConnection");
        Intrinsics.checkNotNullParameter(connectionIssueHandler, (String)"connectionIssueHandler");
        return new RedisHeimdallConnection(delegateConnection, connectionIssueHandler);
    }

    public void cleanupBeforeReconnecting() {
    }

    private static final void _init_$lambda-3(RedisHeimdallImpl this$0, Promise closingPromise) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object2 = this$0;
        try {
            RedisHeimdallImpl $this$lambda_u2d3_u24lambda_u2d0 = object2;
            boolean bl = false;
            $this$lambda_u2d3_u24lambda_u2d0.close();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable $this$lambda_u2d3_u24lambda_u2d0) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$lambda_u2d3_u24lambda_u2d0));
        }
        object2 = object;
        if (Result.isSuccess-impl((Object)object2)) {
            Unit it = (Unit)object2;
            boolean bl = false;
            closingPromise.complete();
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            closingPromise.fail(it);
        }
    }

    private static final void connect$lambda-4(RedisHeimdallImpl this$0, Promise $promise, RedisConnection connection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
        RedisHeimdallConnection connectionImpl = this$0.getConnectionImplementation(connection, (Handler<Throwable>)((Handler)this$0::handleConnectionFailure)).initConnection();
        $promise.complete((Object)connectionImpl);
    }

    private static final void connect$lambda-5(Promise $promise, RedisHeimdallImpl this$0, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (cause instanceof ConnectionPoolTooBusyException) {
            $promise.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CLIENT_BUSY, "Too many commands to Redis at once, please use a rate limiting or increase RedisOptions.maxPoolSize", cause));
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)cause, (String)"cause");
            this$0.handleConnectionFailure(cause);
            $promise.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, cause, 2, null));
        }
    }

    private static final void send$lambda-8$lambda-7(RedisHeimdallImpl this$0, Promise $promise, RedisConnection $conn, AsyncResult send2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conn, (String)"$conn");
        Intrinsics.checkNotNullParameter((Object)send2, (String)"send");
        RedisHeimdallImpl redisHeimdallImpl = this$0;
        try {
            RedisHeimdallImpl $this$send_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6 = redisHeimdallImpl;
            boolean bl = false;
            Object object = Result.constructor-impl((Object)$conn.close());
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        $promise.handle(send2);
    }

    private static final void send$lambda-8(Request $command, RedisHeimdallImpl this$0, Promise $promise, RedisConnection conn) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        conn.send($command).onComplete(arg_0 -> RedisHeimdallImpl.send$lambda-8$lambda-7(this$0, $promise, conn, arg_0));
    }

    private static final void send$lambda-9(Promise $promise, Throwable it) {
        $promise.fail(it);
    }

    private static final void batch$lambda-12$lambda-11(RedisHeimdallImpl this$0, Promise $promise, RedisConnection $conn, AsyncResult send2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conn, (String)"$conn");
        Intrinsics.checkNotNullParameter((Object)send2, (String)"send");
        RedisHeimdallImpl redisHeimdallImpl = this$0;
        try {
            RedisHeimdallImpl $this$batch_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d10 = redisHeimdallImpl;
            boolean bl = false;
            Object object = Result.constructor-impl((Object)$conn.close());
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        $promise.handle(send2);
    }

    private static final void batch$lambda-12(List $commands, RedisHeimdallImpl this$0, Promise $promise, RedisConnection conn) {
        Intrinsics.checkNotNullParameter((Object)$commands, (String)"$commands");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        conn.batch($commands).onComplete(arg_0 -> RedisHeimdallImpl.batch$lambda-12$lambda-11(this$0, $promise, conn, arg_0));
    }

    private static final void batch$lambda-13(Promise $promise, Throwable it) {
        $promise.fail(it);
    }

    private static final void handleConnectionFailure$lambda-18$lambda-16(RedisHeimdallImpl this$0, CompositeFuture it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.sendReconnectingSucceededEvent();
    }

    private static final void handleConnectionFailure$lambda-18$lambda-17(RedisHeimdallImpl this$0, Throwable $cause, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cause, (String)"$cause");
        this$0.logger.warn((Object)"At least one post reconnect job did fail. So we re-initiate reconnection process");
        this$0.handleConnectionFailure($cause);
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleConnectionFailure$lambda-18(RedisHeimdallImpl this$0, Throwable $cause, Redis it) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cause, (String)"$cause");
        RedisHeimdallImpl redisHeimdallImpl = this$0;
        try {
            RedisHeimdallImpl $this$handleConnectionFailure_u24lambda_u2d18_u24lambda_u2d14 = redisHeimdallImpl;
            boolean bl = false;
            $this$handleConnectionFailure_u24lambda_u2d18_u24lambda_u2d14.delegate.close();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable $this$handleConnectionFailure_u24lambda_u2d18_u24lambda_u2d14) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$handleConnectionFailure_u24lambda_u2d18_u24lambda_u2d14));
        }
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.delegate = it;
        this$0.reconnectingInProgress = false;
        Iterable $this$map$iv = this$0.postReconnectJobs;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void job;
            PostReconnectJob postReconnectJob = (PostReconnectJob)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(job.execute(this$0));
        }
        List jobs = (List)destination$iv$iv;
        CompositeFuture jobsResult = CompositeFuture.all((List)jobs);
        jobsResult.onSuccess(arg_0 -> RedisHeimdallImpl.handleConnectionFailure$lambda-18$lambda-16(this$0, arg_0));
        jobsResult.onFailure(arg_0 -> RedisHeimdallImpl.handleConnectionFailure$lambda-18$lambda-17(this$0, $cause, arg_0));
    }

    private static final void handleConnectionFailure$lambda-19(RedisHeimdallImpl this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.sendReconnectingFailedEvent(it);
    }
}

