/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.connection;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.types.ErrorType;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0016J-\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\b0\bH\u0096\u0001JG\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00010\u000124\u0010\u0011\u001a0\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0017\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00120\u0004\u00a2\u0006\u0002\b\u0012H\u0097\u0001J=\u0010\u0013\u001a\n \u000f*\u0004\u0018\u00010\u00010\u00012*\u0010\u0011\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u0005 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004H\u0097\u0001J\u0019\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0015H\u0097\u0001JG\u0010\u0016\u001a\n \u000f*\u0004\u0018\u00010\u00010\u000124\u0010\u0011\u001a0\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n \u000f*\u0017\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00120\u0004\u00a2\u0006\u0002\b\u0012H\u0097\u0001J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0012\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002J\u0011\u0010\u001f\u001a\n \u000f*\u0004\u0018\u00010\u00010\u0001H\u0097\u0001J\t\u0010 \u001a\u00020!H\u0096\u0001J\u0011\u0010\"\u001a\n \u000f*\u0004\u0018\u00010\u00010\u0001H\u0097\u0001J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010$\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/connection/RedisHeimdallConnection;", "Lio/vertx/redis/client/RedisConnection;", "delegate", "connectionIssueHandler", "Lio/vertx/core/Handler;", "", "(Lio/vertx/redis/client/RedisConnection;Lio/vertx/core/Handler;)V", "batch", "Lio/vertx/core/Future;", "", "Lio/vertx/redis/client/Response;", "commands", "Lio/vertx/redis/client/Request;", "close", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "endHandler", "p0", "Lio/vertx/codegen/annotations/Nullable;", "exceptionHandler", "fetch", "", "handler", "initConnection", "mapConnectionIssueException", "", "promise", "Lio/vertx/core/Promise;", "cause", "onConnectionEnd", "void", "pause", "pendingQueueFull", "", "resume", "send", "command", "vertx-redis-client-heimdall"})
public class RedisHeimdallConnection
implements RedisConnection {
    @NotNull
    private final RedisConnection delegate;
    @NotNull
    private final Handler<Throwable> connectionIssueHandler;

    public RedisHeimdallConnection(@NotNull RedisConnection delegate, @NotNull Handler<Throwable> connectionIssueHandler) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(connectionIssueHandler, (String)"connectionIssueHandler");
        this.delegate = delegate;
        this.connectionIssueHandler = connectionIssueHandler;
    }

    public Future<Void> close() {
        return this.delegate.close();
    }

    public RedisConnection endHandler(Handler<Void> p0) {
        return this.delegate.endHandler(p0);
    }

    public RedisConnection exceptionHandler(Handler<Throwable> p0) {
        return this.delegate.exceptionHandler(p0);
    }

    public RedisConnection fetch(long p0) {
        return this.delegate.fetch(p0);
    }

    public RedisConnection handler(Handler<Response> p0) {
        return this.delegate.handler(p0);
    }

    public RedisConnection pause() {
        return this.delegate.pause();
    }

    public boolean pendingQueueFull() {
        return this.delegate.pendingQueueFull();
    }

    public RedisConnection resume() {
        return this.delegate.resume();
    }

    @NotNull
    public RedisHeimdallConnection initConnection() {
        this.endHandler((Handler<Void>)((Handler)this::onConnectionEnd));
        return this;
    }

    @NotNull
    public Future<Response> send(@NotNull Request command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Promise promise = Promise.promise();
        this.delegate.exceptionHandler(arg_0 -> RedisHeimdallConnection.send$lambda-0(this, promise, arg_0));
        this.delegate.send(command).onSuccess(arg_0 -> RedisHeimdallConnection.send$lambda-1(promise, arg_0)).onFailure(arg_0 -> RedisHeimdallConnection.send$lambda-2(this, promise, arg_0));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    @NotNull
    public Future<List<Response>> batch(@NotNull List<? extends Request> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Promise promise = Promise.promise();
        this.delegate.exceptionHandler(arg_0 -> RedisHeimdallConnection.batch$lambda-3(this, promise, arg_0));
        this.delegate.batch(commands).onSuccess(arg_0 -> RedisHeimdallConnection.batch$lambda-4(promise, arg_0)).onFailure(arg_0 -> RedisHeimdallConnection.batch$lambda-5(this, promise, arg_0));
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    private final void mapConnectionIssueException(Promise<?> promise, Throwable cause) {
        Throwable throwable;
        RedisHeimdallException it;
        RedisHeimdallException redisHeimdallException;
        if (cause instanceof ErrorType) {
            if (Intrinsics.areEqual((Object)cause.toString(), (Object)"CONNECTION_CLOSED")) {
                it = redisHeimdallException = new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, cause.toString(), cause);
                boolean bl = false;
                this.connectionIssueHandler.handle((Object)it);
                throwable = redisHeimdallException;
            } else {
                throwable = cause;
            }
        } else if (cause instanceof RedisHeimdallException) {
            throwable = cause;
        } else if (cause instanceof ClosedChannelException) {
            it = redisHeimdallException = new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, cause.getMessage(), cause);
            boolean bl = false;
            this.connectionIssueHandler.handle((Object)it);
            throwable = redisHeimdallException;
        } else if (cause instanceof IOException && Intrinsics.areEqual((Object)cause.getMessage(), (Object)"Broken pipe")) {
            it = redisHeimdallException = new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, cause.getMessage(), cause);
            boolean bl = false;
            this.connectionIssueHandler.handle((Object)it);
            throwable = redisHeimdallException;
        } else {
            throwable = new RedisHeimdallException(RedisHeimdallException.Reason.UNSPECIFIED, cause.getMessage(), cause);
        }
        Throwable finalCause = throwable;
        promise.tryFail(finalCause);
    }

    private final void onConnectionEnd(Void void_) {
        this.connectionIssueHandler.handle((Object)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, "Connection did end", null, 4, null));
    }

    private static final void send$lambda-0(RedisHeimdallConnection this$0, Promise $promise, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RedisHeimdallException exception = new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, "Connection issue catched by exception handler", it);
        this$0.connectionIssueHandler.handle((Object)exception);
        $promise.tryFail((Throwable)exception);
    }

    private static final void send$lambda-1(Promise $promise, Response it) {
        $promise.tryComplete((Object)it);
    }

    private static final void send$lambda-2(RedisHeimdallConnection this$0, Promise $promise, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)$promise, (String)"promise");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.mapConnectionIssueException($promise, it);
    }

    private static final void batch$lambda-3(RedisHeimdallConnection this$0, Promise $promise, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RedisHeimdallException exception = new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, it, 2, null);
        this$0.connectionIssueHandler.handle((Object)exception);
        $promise.tryFail((Throwable)exception);
    }

    private static final void batch$lambda-4(Promise $promise, List it) {
        $promise.tryComplete((Object)it);
    }

    private static final void batch$lambda-5(RedisHeimdallConnection this$0, Promise $promise, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)$promise, (String)"promise");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.mapConnectionIssueException($promise, it);
    }
}

