/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.reconnect.AbstractRedisReconnectProcess;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0002J\u001e\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\f*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001a0\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/DefaultRedisReconnectProcess;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/AbstractRedisReconnectProcess;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "maxReconnectAttempts", "", "reconnectInterval", "", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;IJ)V", "reconnect", "", "promise", "Lio/vertx/core/Promise;", "Lio/vertx/redis/client/Redis;", "previousAttempts", "scheduleReattempt", "startReconnectProcess", "Lio/vertx/core/Future;", "cause", "", "verifyConnection", "Lio/vertx/redis/client/RedisConnection;", "handler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Companion", "vertx-redis-client-heimdall"})
public final class DefaultRedisReconnectProcess
extends AbstractRedisReconnectProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    private final int maxReconnectAttempts;
    private final long reconnectInterval;
    private static final Logger logger = LoggerFactory.getLogger(DefaultRedisReconnectProcess.class);

    public DefaultRedisReconnectProcess(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options, int maxReconnectAttempts, long reconnectInterval) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.vertx = vertx;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.reconnectInterval = reconnectInterval;
    }

    public /* synthetic */ DefaultRedisReconnectProcess(Vertx vertx, RedisHeimdallOptions redisHeimdallOptions, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = redisHeimdallOptions.getMaxReconnectAttempts();
        }
        if ((n2 & 8) != 0) {
            l = redisHeimdallOptions.getReconnectInterval();
        }
        this(vertx, redisHeimdallOptions, n, l);
    }

    @Override
    @NotNull
    public Future<Redis> startReconnectProcess(@NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Promise promise = Promise.promise();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"promise");
        DefaultRedisReconnectProcess.reconnect$default(this, promise, 0, 2, null);
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"promise.future()");
        return future;
    }

    private final void reconnect(Promise<Redis> promise, int previousAttempts) {
        int n = this.maxReconnectAttempts;
        boolean bl = 1 <= n ? n <= previousAttempts : false;
        if (bl) {
            logger.warn((Object)("Max attempts to reconnect to Redis server(s) " + this.getOptions().endpointsToString() + " reached. Will skip."));
            promise.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.MAX_ATTEMPTS_REACHED, "Max number of reconnect attempts \"" + this.maxReconnectAttempts + "\" to Redis server(s) " + this.getOptions().endpointsToString(), null, 4, null));
        } else {
            Redis client = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.getOptions().getRedisOptions());
            client.connect().onSuccess(arg_0 -> DefaultRedisReconnectProcess.reconnect$lambda-1(this, promise, client, previousAttempts, arg_0)).onFailure(arg_0 -> DefaultRedisReconnectProcess.reconnect$lambda-2(this, promise, previousAttempts, arg_0));
        }
    }

    static /* synthetic */ void reconnect$default(DefaultRedisReconnectProcess defaultRedisReconnectProcess, Promise promise, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        defaultRedisReconnectProcess.reconnect((Promise<Redis>)promise, n);
    }

    private final void scheduleReattempt(Promise<Redis> promise, int previousAttempts) {
        logger.debug((Object)("Unable to reconnect to Redis server(s) " + this.getOptions().endpointsToString() + ". Will retry in " + this.reconnectInterval + " Milliseconds"));
        this.vertx.setTimer(this.reconnectInterval, arg_0 -> DefaultRedisReconnectProcess.scheduleReattempt$lambda-3(this, promise, previousAttempts, arg_0));
    }

    private final void verifyConnection(RedisConnection $this$verifyConnection, Handler<AsyncResult<Unit>> handler) {
        $this$verifyConnection.send(Request.cmd((Command)Command.PING), arg_0 -> DefaultRedisReconnectProcess.verifyConnection$lambda-4(handler, arg_0));
    }

    private static final void reconnect$lambda-1$lambda-0(RedisConnection $connection, DefaultRedisReconnectProcess this$0, Promise $promise, Redis $client, int $previousAttempts, AsyncResult verification) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        $connection.close();
        if (verification.succeeded()) {
            logger.info((Object)("Redis client reconnected to server(s) " + this$0.getOptions().endpointsToString()));
            $promise.complete((Object)$client);
        } else {
            this$0.scheduleReattempt((Promise<Redis>)$promise, $previousAttempts);
        }
    }

    private static final void reconnect$lambda-1(DefaultRedisReconnectProcess this$0, Promise $promise, Redis $client, int $previousAttempts, RedisConnection connection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
        this$0.verifyConnection(connection, (Handler<AsyncResult<Unit>>)((Handler)arg_0 -> DefaultRedisReconnectProcess.reconnect$lambda-1$lambda-0(connection, this$0, $promise, $client, $previousAttempts, arg_0)));
    }

    private static final void reconnect$lambda-2(DefaultRedisReconnectProcess this$0, Promise $promise, int $previousAttempts, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        this$0.scheduleReattempt((Promise<Redis>)$promise, $previousAttempts);
    }

    private static final void scheduleReattempt$lambda-3(DefaultRedisReconnectProcess this$0, Promise $promise, int $previousAttempts, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        this$0.reconnect((Promise<Redis>)$promise, $previousAttempts + 1);
    }

    private static final void verifyConnection$lambda-4(Handler $handler, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        if (it.succeeded() && Intrinsics.areEqual((Object)it.result().toString(), (Object)"PONG")) {
            $handler.handle((Object)Future.succeededFuture());
        } else {
            $handler.handle((Object)Future.failedFuture((Throwable)it.cause()));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/reconnect/DefaultRedisReconnectProcess$Companion;", "", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "vertx-redis-client-heimdall"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

