/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall;

import ch.sourcemotion.vertx.redis.client.heimdall.PendingCommand;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdall;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallLight;
import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallOptions;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.PostReconnectJob;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.RedisHeimdallImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayDeque;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\b\u0010%\u001a\u0004\u0018\u00010\u0016H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallLight;", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdall;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/PostReconnectJob;", "vertx", "Lio/vertx/core/Vertx;", "options", "Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;", "(Lio/vertx/core/Vertx;Lch/sourcemotion/vertx/redis/client/heimdall/RedisHeimdallOptions;)V", "connection", "Lio/vertx/redis/client/RedisConnection;", "pendingStartCommands", "Ljava/util/ArrayDeque;", "Lch/sourcemotion/vertx/redis/client/heimdall/PendingCommand;", "redisHeimdall", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/RedisHeimdallImpl;", "started", "", "batch", "Lio/vertx/core/Future;", "", "Lio/vertx/redis/client/Response;", "commands", "Lio/vertx/redis/client/Request;", "cancelPendingStartCommands", "", "cause", "", "close", "connect", "execute", "redis", "Lio/vertx/redis/client/Redis;", "executePendingStartCommands", "getConnection", "handleIfConnectionIssue", "mayStart", "send", "command", "vertx-redis-client-heimdall"})
public final class RedisHeimdallLight
implements RedisHeimdall,
PostReconnectJob {
    @NotNull
    private RedisHeimdallImpl redisHeimdall;
    private boolean started;
    @Nullable
    private RedisConnection connection;
    @NotNull
    private final ArrayDeque<PendingCommand> pendingStartCommands;

    public RedisHeimdallLight(@NotNull Vertx vertx, @NotNull RedisHeimdallOptions options) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.redisHeimdall = new RedisHeimdallImpl(vertx, options, CollectionsKt.listOf((Object)this));
        this.pendingStartCommands = new ArrayDeque();
        RedisHeimdallLight.mayStart$default(this, null, 1, null);
    }

    @NotNull
    public Future<Response> send(@Nullable Request command) {
        Promise p = Promise.promise();
        RedisConnection conn = this.connection;
        RedisConnection redisConnection = conn;
        if (redisConnection != null) {
            redisConnection.send(command).onFailure(arg_0 -> RedisHeimdallLight.send$lambda$0(this, p, arg_0)).onSuccess(arg_0 -> RedisHeimdallLight.send$lambda$1(p, arg_0));
        } else if (!this.started) {
            this.pendingStartCommands.add(new PendingCommand((Promise<Response>)p, command, this){
                final /* synthetic */ Promise<Response> $p;
                final /* synthetic */ Request $command;
                final /* synthetic */ RedisHeimdallLight this$0;
                {
                    this.$p = $p;
                    this.$command = $command;
                    this.this$0 = $receiver;
                    Intrinsics.checkNotNullExpressionValue($p, (String)"p");
                    super($p);
                }

                public void execute(@NotNull RedisConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    connection.send(this.$command).onFailure(arg_0 -> send.3.execute$lambda$0(this.this$0, this.$p, arg_0)).onSuccess(arg_0 -> send.3.execute$lambda$1(this.$p, arg_0));
                }

                private static final void execute$lambda$0(RedisHeimdallLight this$0, Promise $p, Throwable cause) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullExpressionValue((Object)cause, (String)"cause");
                    RedisHeimdallLight.access$handleIfConnectionIssue(this$0, cause);
                    $p.fail(cause);
                }

                private static final void execute$lambda$1(Promise $p, Response response) {
                    $p.complete((Object)response);
                }
            });
        } else if (this.redisHeimdall.getReconnectingInProgress()) {
            p.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, null, null, 6, null));
        } else {
            p.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, null, 6, null));
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    @NotNull
    public Future<List<Response>> batch(@Nullable List<? extends Request> commands) {
        Promise p = Promise.promise();
        RedisConnection conn = this.connection;
        RedisConnection redisConnection = conn;
        if (redisConnection != null) {
            redisConnection.batch(commands).onFailure(arg_0 -> RedisHeimdallLight.batch$lambda$2(this, p, arg_0)).onSuccess(arg_0 -> RedisHeimdallLight.batch$lambda$3(p, arg_0));
        } else if (!this.started) {
            this.pendingStartCommands.add(new PendingCommand((Promise<List<Response>>)p, commands, this){
                final /* synthetic */ Promise<List<Response>> $p;
                final /* synthetic */ List<Request> $commands;
                final /* synthetic */ RedisHeimdallLight this$0;
                {
                    this.$p = $p;
                    this.$commands = $commands;
                    this.this$0 = $receiver;
                    Intrinsics.checkNotNullExpressionValue($p, (String)"p");
                    super($p);
                }

                public void execute(@NotNull RedisConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    connection.batch(this.$commands).onFailure(arg_0 -> batch.3.execute$lambda$0(this.this$0, this.$p, arg_0)).onSuccess(arg_0 -> batch.3.execute$lambda$1(this.$p, arg_0));
                }

                private static final void execute$lambda$0(RedisHeimdallLight this$0, Promise $p, Throwable cause) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullExpressionValue((Object)cause, (String)"cause");
                    RedisHeimdallLight.access$handleIfConnectionIssue(this$0, cause);
                    $p.fail(cause);
                }

                private static final void execute$lambda$1(Promise $p, List responses) {
                    $p.complete((Object)responses);
                }
            });
        } else if (this.redisHeimdall.getReconnectingInProgress()) {
            p.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, null, null, 6, null));
        } else {
            p.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, null, 6, null));
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    @NotNull
    public Future<RedisConnection> connect() {
        Promise p = Promise.promise();
        RedisConnection conn = this.connection;
        RedisConnection redisConnection = conn;
        if (redisConnection != null) {
            p.complete((Object)redisConnection);
        } else if (!this.started) {
            this.pendingStartCommands.add(new PendingCommand((Promise<RedisConnection>)p){
                final /* synthetic */ Promise<RedisConnection> $p;
                {
                    this.$p = $p;
                    Intrinsics.checkNotNullExpressionValue($p, (String)"p");
                    super($p);
                }

                public void execute(@NotNull RedisConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    this.$p.complete((Object)connection);
                }
            });
        } else if (this.redisHeimdall.getReconnectingInProgress()) {
            p.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.ACCESS_DURING_RECONNECT, null, null, 6, null));
        } else {
            p.fail((Throwable)new RedisHeimdallException(RedisHeimdallException.Reason.CONNECTION_ISSUE, null, null, 6, null));
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    private final void handleIfConnectionIssue(Throwable cause) {
        if (cause instanceof RedisHeimdallException && ((RedisHeimdallException)cause).getReason() == RedisHeimdallException.Reason.CONNECTION_ISSUE) {
            RedisConnection redisConnection = this.connection;
            if (redisConnection != null) {
                redisConnection.close();
            }
            this.connection = null;
        }
    }

    @Override
    @NotNull
    public Future<Unit> execute(@NotNull Redis redis) {
        Intrinsics.checkNotNullParameter((Object)redis, (String)"redis");
        Promise p = Promise.promise();
        this.getConnection().onSuccess(arg_0 -> RedisHeimdallLight.execute$lambda$4(this, p, arg_0)).onFailure(arg_0 -> RedisHeimdallLight.execute$lambda$5(p, arg_0));
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    private final Future<RedisConnection> getConnection() {
        Promise p = Promise.promise();
        if (this.connection != null) {
            p.complete((Object)this.connection);
        } else {
            this.redisHeimdall.connect(arg_0 -> RedisHeimdallLight.getConnection$lambda$6(p, arg_0));
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    private final Future<Unit> mayStart(RedisConnection connection) {
        Promise p = Promise.promise();
        if (this.started) {
            p.complete();
        } else if (connection != null) {
            Object $this$mayStart_u24lambda_u247;
            Object object = this;
            try {
                $this$mayStart_u24lambda_u247 = object;
                boolean bl = false;
                super.executePendingStartCommands(connection);
                $this$mayStart_u24lambda_u247 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$mayStart_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$mayStart_u24lambda_u247;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                p.complete();
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                p.fail(it);
            }
        } else {
            this.getConnection().onSuccess(arg_0 -> RedisHeimdallLight.mayStart$lambda$10(this, p, arg_0)).onFailure(arg_0 -> RedisHeimdallLight.mayStart$lambda$11(this, arg_0));
        }
        Future future = p.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"p.future()");
        return future;
    }

    static /* synthetic */ Future mayStart$default(RedisHeimdallLight redisHeimdallLight, RedisConnection redisConnection, int n, Object object) {
        if ((n & 1) != 0) {
            redisConnection = null;
        }
        return redisHeimdallLight.mayStart(redisConnection);
    }

    private final void cancelPendingStartCommands(Throwable cause) {
        PendingCommand pendingCommand = this.pendingStartCommands.poll();
        while (pendingCommand != null) {
            pendingCommand.cancel(cause);
            pendingCommand = this.pendingStartCommands.poll();
        }
    }

    private final void executePendingStartCommands(RedisConnection connection) {
        if (!this.started) {
            PendingCommand pendingCommand = this.pendingStartCommands.poll();
            while (pendingCommand != null) {
                pendingCommand.execute(connection);
                pendingCommand = this.pendingStartCommands.poll();
            }
            this.started = true;
        }
    }

    @Override
    public void close() {
        RedisConnection redisConnection = this.connection;
        if (redisConnection != null) {
            redisConnection.close();
        }
        this.redisHeimdall.close();
    }

    private static final void send$lambda$0(RedisHeimdallLight this$0, Promise $p, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)cause, (String)"cause");
        this$0.handleIfConnectionIssue(cause);
        $p.fail(cause);
    }

    private static final void send$lambda$1(Promise $p, Response response) {
        $p.complete((Object)response);
    }

    private static final void batch$lambda$2(RedisHeimdallLight this$0, Promise $p, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)cause, (String)"cause");
        this$0.handleIfConnectionIssue(cause);
        $p.fail(cause);
    }

    private static final void batch$lambda$3(Promise $p, List responses) {
        $p.complete((Object)responses);
    }

    private static final void execute$lambda$4(RedisHeimdallLight this$0, Promise $p, RedisConnection it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.connection = it;
        this$0.mayStart(it).onComplete((Handler)$p);
    }

    private static final void execute$lambda$5(Promise $p, Throwable it) {
        $p.fail(it);
    }

    private static final void getConnection$lambda$6(Promise $p, AsyncResult result) {
        if (result.succeeded()) {
            $p.complete(result.result());
        } else {
            $p.fail(result.cause());
        }
    }

    private static final void mayStart$lambda$10(RedisHeimdallLight this$0, Promise $p, RedisConnection conn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
        this$0.executePendingStartCommands(conn);
        this$0.connection = conn;
        this$0.started = true;
        $p.complete();
    }

    private static final void mayStart$lambda$11(RedisHeimdallLight this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.cancelPendingStartCommands(it);
    }

    public static final /* synthetic */ void access$handleIfConnectionIssue(RedisHeimdallLight $this, Throwable cause) {
        $this.handleIfConnectionIssue(cause);
    }
}

