/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection;

import ch.sourcemotion.vertx.redis.client.heimdall.RedisHeimdallException;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.connection.RedisHeimdallConnection;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.RedisHeimdallSubscriptionImplKt;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.SubscriptionStore;
import ch.sourcemotion.vertx.redis.client.heimdall.impl.subscription.connection.RedisHeimdallSubscriptionConnectionKt;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/connection/RedisHeimdallSubscriptionConnection;", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/connection/RedisHeimdallConnection;", "delegate", "Lio/vertx/redis/client/RedisConnection;", "connectionIssueHandler", "Lio/vertx/core/Handler;", "", "subscriptionStore", "Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;", "messageHandler", "Lio/vertx/redis/client/Response;", "(Lio/vertx/redis/client/RedisConnection;Lio/vertx/core/Handler;Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/SubscriptionStore;Lio/vertx/core/Handler;)V", "batch", "Lio/vertx/core/Future;", "", "commands", "Lio/vertx/redis/client/Request;", "handleSubscriptionMessage", "", "response", "handler", "initConnection", "send", "command", "subscribeAfterReconnect", "subscribeToChannelsAndPatterns", "channelNames", "", "channelPatterns", "Companion", "vertx-redis-client-heimdall"})
public final class RedisHeimdallSubscriptionConnection
extends RedisHeimdallConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SubscriptionStore subscriptionStore;
    @NotNull
    private final Handler<Response> messageHandler;
    private static final Logger logger = LoggerFactory.getLogger(RedisHeimdallSubscriptionConnection.class);
    @NotNull
    private static final List<Command> supportedCommands;

    public RedisHeimdallSubscriptionConnection(@NotNull RedisConnection delegate, @NotNull Handler<Throwable> connectionIssueHandler, @NotNull SubscriptionStore subscriptionStore, @NotNull Handler<Response> messageHandler) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(connectionIssueHandler, (String)"connectionIssueHandler");
        Intrinsics.checkNotNullParameter((Object)subscriptionStore, (String)"subscriptionStore");
        Intrinsics.checkNotNullParameter(messageHandler, (String)"messageHandler");
        super(delegate, connectionIssueHandler);
        this.subscriptionStore = subscriptionStore;
        this.messageHandler = messageHandler;
    }

    @Override
    @NotNull
    public RedisHeimdallConnection initConnection() {
        super.initConnection();
        super.handler((Handler<Response>)((Handler)this::handleSubscriptionMessage));
        return this;
    }

    @Override
    @NotNull
    public RedisConnection handler(@NotNull Handler<Response> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        throw new RedisHeimdallException(RedisHeimdallException.Reason.UNSUPPORTED_ACTION, "In subscription mode, you should not register your own subscription handler, as it's handled by Redis Heimdall.", null, 4, null);
    }

    @Override
    @NotNull
    public Future<Response> send(@NotNull Request command) {
        Future future;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Promise promise = Promise.promise();
        Command command2 = command.command();
        Intrinsics.checkNotNullExpressionValue((Object)command2, (String)"command.command()");
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"promise");
        if (RedisHeimdallSubscriptionImplKt.verifySubscriptionCommandOnly(command2, (Promise<Response>)promise)) {
            future = super.send(command);
        } else {
            Future future2 = promise.future();
            future = future2;
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"promise.future()");
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Future<List<Response>> batch(@NotNull List<? extends Request> commands) {
        Future future;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        Promise promise = Promise.promise();
        Iterable $this$map$iv = commands;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Request request = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.command());
        }
        List list = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"promise");
        if (RedisHeimdallSubscriptionImplKt.verifySubscriptionCommandsOnly(list, (Promise<List<Response>>)promise)) {
            future = super.batch(commands);
        } else {
            Future future2 = promise.future();
            future = future2;
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"promise.future()");
        }
        return future;
    }

    @NotNull
    public final Future<Unit> subscribeToChannelsAndPatterns(@NotNull List<String> channelNames, @NotNull List<String> channelPatterns) {
        Future future;
        Request cmd;
        Intrinsics.checkNotNullParameter(channelNames, (String)"channelNames");
        Intrinsics.checkNotNullParameter(channelPatterns, (String)"channelPatterns");
        Promise promise = Promise.promise();
        ArrayList<Future> commandFutures = new ArrayList<Future>();
        if (!((Collection)channelNames).isEmpty()) {
            cmd = Request.cmd((Command)Command.SUBSCRIBE);
            Intrinsics.checkNotNullExpressionValue((Object)cmd, (String)"cmd");
            RedisHeimdallSubscriptionConnectionKt.addToCommandArgs(channelNames, cmd);
            future = this.send(cmd).onSuccess(arg_0 -> RedisHeimdallSubscriptionConnection.subscribeToChannelsAndPatterns$lambda$1(channelNames, arg_0)).onFailure(arg_0 -> RedisHeimdallSubscriptionConnection.subscribeToChannelsAndPatterns$lambda$2(channelNames, arg_0));
            commandFutures.add(future);
        }
        if (!((Collection)channelPatterns).isEmpty()) {
            cmd = Request.cmd((Command)Command.PSUBSCRIBE);
            Intrinsics.checkNotNullExpressionValue((Object)cmd, (String)"cmd");
            RedisHeimdallSubscriptionConnectionKt.addToCommandArgs(channelPatterns, cmd);
            future = this.send(cmd).onSuccess(arg_0 -> RedisHeimdallSubscriptionConnection.subscribeToChannelsAndPatterns$lambda$3(channelPatterns, arg_0)).onFailure(arg_0 -> RedisHeimdallSubscriptionConnection.subscribeToChannelsAndPatterns$lambda$4(channelPatterns, arg_0));
            commandFutures.add(future);
        }
        if (!((Collection)commandFutures).isEmpty()) {
            CompositeFuture.all((List)CollectionsKt.toList((Iterable)commandFutures)).onSuccess(arg_0 -> RedisHeimdallSubscriptionConnection.subscribeToChannelsAndPatterns$lambda$5(promise, arg_0)).onFailure(arg_0 -> RedisHeimdallSubscriptionConnection.subscribeToChannelsAndPatterns$lambda$6(promise, arg_0));
        } else {
            promise.complete();
        }
        Future future2 = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"promise.future()");
        return future2;
    }

    @NotNull
    public final Future<Unit> subscribeAfterReconnect() {
        Collection<String> collection;
        Collection<String> channelNames;
        Collection<String> collection2 = this.subscriptionStore.subscriptions();
        if (collection2 == null || (collection2 = CollectionsKt.toList((Iterable)collection2)) == null) {
            collection2 = channelNames = CollectionsKt.emptyList();
        }
        if ((collection = this.subscriptionStore.patterns()) == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection<String> patterns = collection;
        return this.subscribeToChannelsAndPatterns((List<String>)channelNames, (List<String>)patterns);
    }

    private final void handleSubscriptionMessage(Response response) {
        if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"subscribe")) {
            this.subscriptionStore.addSubscription(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"unsubscribe")) {
            this.subscriptionStore.removeSubscription(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"psubscribe")) {
            this.subscriptionStore.addPattern(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"punsubscribe")) {
            this.subscriptionStore.removePattern(String.valueOf(response.get(1)));
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"message")) {
            this.messageHandler.handle((Object)response);
        } else if (Intrinsics.areEqual((Object)String.valueOf(response.get(0)), (Object)"pmessage")) {
            this.messageHandler.handle((Object)response);
        } else {
            logger.warn((Object)("Response / Message type from Redis not supported \"" + response + "\""));
        }
    }

    private static final void subscribeToChannelsAndPatterns$lambda$1(List $channelNames, Response it) {
        Intrinsics.checkNotNullParameter((Object)$channelNames, (String)"$channelNames");
        logger.info((Object)("Channel(s) " + $channelNames + " subscribed"));
    }

    private static final void subscribeToChannelsAndPatterns$lambda$2(List $channelNames, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$channelNames, (String)"$channelNames");
        logger.warn((Object)("Subscription to channel(s) " + $channelNames + " failed"), it);
    }

    private static final void subscribeToChannelsAndPatterns$lambda$3(List $channelPatterns, Response it) {
        Intrinsics.checkNotNullParameter((Object)$channelPatterns, (String)"$channelPatterns");
        logger.info((Object)("Channel pattern(s) " + $channelPatterns + " subscribed"));
    }

    private static final void subscribeToChannelsAndPatterns$lambda$4(List $channelPatterns, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$channelPatterns, (String)"$channelPatterns");
        logger.warn((Object)("Subscription to channel pattern(s) " + $channelPatterns + " failed"), it);
    }

    private static final void subscribeToChannelsAndPatterns$lambda$5(Promise $promise, CompositeFuture it) {
        $promise.complete();
    }

    private static final void subscribeToChannelsAndPatterns$lambda$6(Promise $promise, Throwable it) {
        $promise.fail(it);
    }

    static {
        Object[] objectArray = new Command[]{Command.SUBSCRIBE, Command.UNSUBSCRIBE, Command.PSUBSCRIBE, Command.PUNSUBSCRIBE};
        supportedCommands = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lch/sourcemotion/vertx/redis/client/heimdall/impl/subscription/connection/RedisHeimdallSubscriptionConnection$Companion;", "", "()V", "logger", "Lio/vertx/core/logging/Logger;", "kotlin.jvm.PlatformType", "supportedCommands", "", "Lio/vertx/redis/client/Command;", "getSupportedCommands", "()Ljava/util/List;", "vertx-redis-client-heimdall"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Command> getSupportedCommands() {
            return supportedCommands;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

