/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.jdbc.flyway;

import ch.sourcepond.jdbc.flyway.MigrationTask;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.sql.DataSource;

final class DataSourceInvocationHandler
implements InvocationHandler {
    private final DataSource wrapped;
    private final MigrationTask task;

    public DataSourceInvocationHandler(DataSource pWrapped, MigrationTask pTask) {
        this.wrapped = pWrapped;
        this.task = pTask;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object other;
        if (Object.class != method.getDeclaringClass()) {
            this.task.awaitMigration();
        } else if ("equals".equals(method.getName()) && (other = args[0]) != null && Proxy.isProxyClass(other.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            if (this.getClass() == ih.getClass()) {
                args[0] = ((DataSourceInvocationHandler)ih).wrapped;
            }
        }
        try {
            return method.invoke((Object)this.wrapped, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

