/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.jdbc.flyway;

import ch.sourcepond.jdbc.flyway.MigrationManager;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataSourceProxyManager
implements FindHook,
EventListenerHook {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceProxyManager.class);
    private static final String FLYWAY_PROXY = "_$FLYWAY_proxy_$";
    private static final String JDBC_DATASOURCE_NAME = "dataSourceName";
    private final Map<ServiceReference<?>, ServiceRegistration<?>> wrappedReferences = new ConcurrentHashMap();
    private final MigrationManager migrationManager;
    private final BundleContext thisContext;

    public DataSourceProxyManager(MigrationManager pMigrationManager, BundleContext pThisContext) {
        this.migrationManager = pMigrationManager;
        this.thisContext = pThisContext;
    }

    private static boolean isDataSource(String ... pClassNameOrNull) {
        if (pClassNameOrNull != null) {
            for (String className : pClassNameOrNull) {
                if (!DataSource.class.getName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotThis(BundleContext pBundleContext) {
        return !this.thisContext.equals(pBundleContext);
    }

    private Hashtable<String, Object> buildProxyProperties(ServiceReference<?> pReference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String key : pReference.getPropertyKeys()) {
            properties.put(key, pReference.getProperty(key));
        }
        properties.put(FLYWAY_PROXY, String.valueOf(true));
        return properties;
    }

    public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
        if (DataSourceProxyManager.isDataSource(name) && this.isNotThis(context)) {
            Iterator<ServiceReference<?>> it = references.iterator();
            while (it.hasNext()) {
                ServiceReference<?> ref = it.next();
                if (ref.getProperty(FLYWAY_PROXY) != null) continue;
                LOG.debug("{0} should get a proxy [ name: {1}, filter: {2} ]; removing original reference [ {3} ]", new Object[]{context.getBundle(), name, filter, ref});
                it.remove();
            }
        }
    }

    public void event(ServiceEvent event, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> listeners) {
        ServiceReference serviceReference = event.getServiceReference();
        String[] classNames = (String[])serviceReference.getProperty("objectClass");
        if (DataSourceProxyManager.isDataSource(classNames) && this.isNotThis(serviceReference.getBundle().getBundleContext())) {
            switch (event.getType()) {
                case 1: {
                    String datasourceName = (String)serviceReference.getProperty(JDBC_DATASOURCE_NAME);
                    DataSource wrapped = (DataSource)this.thisContext.getService(serviceReference);
                    this.wrappedReferences.put(serviceReference, this.thisContext.registerService(DataSource.class, (Object)this.migrationManager.startMigration(wrapped, datasourceName), this.buildProxyProperties(serviceReference)));
                    listeners.clear();
                    break;
                }
                case 4: {
                    ServiceRegistration<?> wrapperRegistration = this.wrappedReferences.remove(serviceReference);
                    if (wrapperRegistration == null) break;
                    wrapperRegistration.unregister();
                    this.thisContext.ungetService(serviceReference);
                    listeners.clear();
                    break;
                }
            }
        }
    }
}

