/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.jdbc.flyway;

import ch.sourcepond.jdbc.flyway.MigrationTask;
import ch.sourcepond.jdbc.flyway.ProxyFactory;
import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationManager.class);
    private static final String ROOT_LOCATION = "db";
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final ProxyFactory proxyFactory = new ProxyFactory();
    private final BundleContext bundleContext;

    public MigrationManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource startMigration(DataSource pDataSource, String pDataSourceName) {
        String path = pDataSourceName == null ? String.format("%s", ROOT_LOCATION) : String.format("%s/%s", ROOT_LOCATION, pDataSourceName);
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Flyway.class.getClassLoader());
        try {
            Flyway flyway = new Flyway();
            flyway.setLocations(new String[]{path});
            flyway.setDataSource(pDataSource);
            MigrationTask task = new MigrationTask(flyway);
            this.executorService.execute(task);
            LOG.info("Started migration for datasource '{}' and [{}]", (Object)pDataSourceName, (Object)path);
            DataSource dataSource = this.proxyFactory.createProxy(pDataSource, task);
            return dataSource;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ldr);
        }
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.warn("DB-Migration interrupted, leaving the database in a potentially corrupted state!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

