/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.jdbc.flyway;

import java.sql.SQLException;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MigrationTask
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationTask.class);
    private final Flyway flyway;
    private volatile boolean migrate = true;
    private volatile SQLException migrationFailure;

    public MigrationTask(Flyway pFlyway) {
        this.flyway = pFlyway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitMigration() throws SQLException {
        if (this.migrate) {
            MigrationTask migrationTask = this;
            synchronized (migrationTask) {
                while (this.migrate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.migrate = false;
                        this.migrationFailure = new SQLException(e.getMessage(), e);
                        MigrationTask.currentThread().interrupt();
                    }
                }
            }
        }
        if (this.migrationFailure != null) {
            throw this.migrationFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.flyway.migrate();
        }
        catch (FlywayException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.migrationFailure = new SQLException(e.getMessage(), e);
        }
        finally {
            this.migrate = false;
            MigrationTask migrationTask = this;
            synchronized (migrationTask) {
                this.notifyAll();
            }
        }
    }
}

