/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class ResourceFinderClassLoader
extends ClassLoader {
    private final BundleContext context;

    public ResourceFinderClassLoader(BundleContext context) {
        super(ResourceFinderClassLoader.getClassLoader(context.getBundle()));
        this.context = context;
    }

    private static ClassLoader getClassLoader(Bundle bundle) {
        return ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        LinkedList<URL> resources = new LinkedList<URL>();
        for (Bundle b : this.context.getBundles()) {
            ClassLoader cl = ResourceFinderClassLoader.getClassLoader(b);
            if (cl == null) continue;
            Enumeration<URL> e = cl.getResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }
}

