/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import ch.sourcepond.spring.web.blueprint.internal.BundleSpaceResolver;
import ch.sourcepond.spring.web.blueprint.internal.ClasspathResolver;
import ch.sourcepond.spring.web.blueprint.internal.InternalResolver;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class BundleResourcePatternResolver
implements ResourcePatternResolver {
    private static final Object MONITOR = new Object();
    static final String CLASSPATH_URL_PREFIX = "classpath:";
    static final String CLASSPATHS_URL_PREFIX = "classpath*:";
    static final String OSGI_BUNDLE_URL_PREFIX = "osgibundle:";
    static final String PREFIX_UNSPECIFIED = "";
    static final char PROTOCOL_SEPARATOR = ':';
    private static volatile BundleContext bundleContext;
    private final Map<String, InternalResolver> accessors = new HashMap<String, InternalResolver>();
    private final Bundle bundle;
    private final ResourcePatternResolver patternResolver;

    BundleResourcePatternResolver(Bundle bundle, ResourcePatternResolver patternResolver) {
        this(bundle, patternResolver, new ClasspathResolver((PathMatcher)new AntPathMatcher()), new BundleSpaceResolver((PathMatcher)new AntPathMatcher()));
    }

    BundleResourcePatternResolver(Bundle bundle, ResourcePatternResolver patternResolver, InternalResolver classpathResolver, InternalResolver bundlespaceResolver) {
        this.bundle = bundle;
        this.patternResolver = patternResolver;
        this.accessors.put(CLASSPATH_URL_PREFIX, classpathResolver);
        this.accessors.put(CLASSPATHS_URL_PREFIX, classpathResolver);
        this.accessors.put(OSGI_BUNDLE_URL_PREFIX, bundlespaceResolver);
        this.accessors.put(PREFIX_UNSPECIFIED, bundlespaceResolver);
    }

    private InternalResolver getResolverOrNull(String pProtocolPrefix) {
        return this.accessors.get(pProtocolPrefix);
    }

    private String extractProtocol(String pLocationPattern) {
        int protocolSeparatorIdx = pLocationPattern.indexOf(58) + 1;
        return pLocationPattern.substring(0, protocolSeparatorIdx);
    }

    public final Resource getResource(String path) {
        URL resourceUrl;
        String protocol = this.extractProtocol(path);
        String normalizedLocationPattern = path.substring(protocol.length());
        InternalResolver resolver = this.getResolverOrNull(protocol);
        Object foundResource = resolver == null ? this.patternResolver.getResource(path) : ((resourceUrl = resolver.resolveResource(this.bundle, normalizedLocationPattern)) == null ? null : new UrlResource(resourceUrl));
        return foundResource;
    }

    public final ClassLoader getClassLoader() {
        return ((BundleWiring)this.bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    public final Resource[] getResources(String pattern) throws IOException {
        Resource[] foundResources;
        String protocol = this.extractProtocol(pattern);
        String normalizedPathPattern = pattern.substring(protocol.length());
        InternalResolver resolver = this.getResolverOrNull(protocol);
        if (resolver == null) {
            foundResources = this.patternResolver.getResources(pattern);
        } else {
            Collection<URL> foundResourceUrls = resolver.resolveResources(this.bundle, normalizedPathPattern);
            if (foundResourceUrls.isEmpty()) {
                foundResources = this.patternResolver.getResources(pattern);
            } else {
                foundResources = new Resource[foundResourceUrls.size()];
                int i = 0;
                for (URL foundResourceUrl : foundResourceUrls) {
                    foundResources[i++] = new UrlResource(foundResourceUrl);
                }
            }
        }
        return foundResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBundleContext(BundleContext b) {
        Object object = MONITOR;
        synchronized (object) {
            bundleContext = b;
            MONITOR.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BundleContext getBundleContext() {
        if (bundleContext == null) {
            Object object = MONITOR;
            synchronized (object) {
                if (bundleContext == null) {
                    try {
                        while (bundleContext == null) {
                            MONITOR.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
            }
        }
        return bundleContext;
    }

    public static ResourcePatternResolver create(ResourcePatternResolver delegate) {
        return new BundleResourcePatternResolver(BundleResourcePatternResolver.getBundleContext().getBundle(), delegate);
    }
}

