/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import ch.sourcepond.spring.web.blueprint.internal.InternalResolver;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.springframework.util.PathMatcher;

class BundleSpaceResolver
extends InternalResolver<URL> {
    BundleSpaceResolver(PathMatcher matcher) {
        super(matcher);
    }

    @Override
    protected Collection<URL> listAllResources(Bundle bundle) {
        Enumeration urls = bundle.findEntries("/", "*", true);
        List<URL> resources = urls == null ? Collections.emptyList() : Collections.list(urls);
        return resources;
    }

    @Override
    protected URL doResolveResource(Bundle bundle, String path) {
        return bundle.getEntry(path);
    }

    @Override
    protected String toPath(URL url, String pattern) {
        String path = url.getPath();
        if (path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }
}

