/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint;

import ch.sourcepond.spring.web.blueprint.XmlWebApplicationBundleContext;
import ch.sourcepond.spring.web.blueprint.internal.BlueprintApplicationContext;
import ch.sourcepond.spring.web.blueprint.internal.ResourceFinderClassLoader;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class BlueprintServletContainerInitializer
implements ServletContainerInitializer,
ServletContextAttributeListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintServletContainerInitializer.class);
    static final String OSGI_BUNDLECONTEXT = "osgi-bundlecontext";
    static final String BLUEPRINT_CONTEXT_CLASS = "blueprintContextClass";
    static final String BLUEPRINT_CONTEXT = "blueprintContext";
    static final String CONTEXT_ATTRIBUTE = "contextAttribute";
    static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";

    static Bundle getBundle(ServletContext context) {
        return ((BundleContext)Objects.requireNonNull(context.getAttribute(OSGI_BUNDLECONTEXT), () -> "osgi-bundlecontext is not set as attribute on ServletContext")).getBundle();
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        ctx.addListener((EventListener)((Object)this));
    }

    private ConfigurableWebApplicationContext createContext(Bundle bundle, String classNameOrNull) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        XmlWebApplicationBundleContext ctx;
        if (classNameOrNull == null) {
            ctx = new XmlWebApplicationBundleContext();
        } else {
            Class cl = bundle.loadClass(classNameOrNull);
            if (!ConfigurableWebApplicationContext.class.isAssignableFrom(cl)) {
                throw new ClassCastException(String.format("Class %s specified by attribute %s must be assignable from %s", cl.getName(), BLUEPRINT_CONTEXT_CLASS, ConfigurableWebApplicationContext.class.getName()));
            }
            ctx = (ConfigurableWebApplicationContext)cl.newInstance();
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(ServletContextAttributeEvent event) {
        if (OSGI_BUNDLECONTEXT.equals(event.getName())) {
            ServletContext sctx = event.getServletContext();
            BundleContext bundleContext = (BundleContext)event.getValue();
            BlueprintApplicationContext blueprintApplicationContext = new BlueprintApplicationContext(sctx, bundleContext);
            try {
                bundleContext.addServiceListener((ServiceListener)blueprintApplicationContext, blueprintApplicationContext.getFilter());
            }
            catch (InvalidSyntaxException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            ClassLoader ldr = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(new ResourceFinderClassLoader(bundleContext));
            try {
                ConfigurableWebApplicationContext webContext = this.createContext(bundleContext.getBundle(), sctx.getInitParameter(BLUEPRINT_CONTEXT_CLASS));
                webContext.setServletContext(sctx);
                webContext.setParent((ApplicationContext)blueprintApplicationContext);
                String configLocationParam = sctx.getInitParameter(CONFIG_LOCATION_PARAM);
                if (configLocationParam != null) {
                    webContext.setConfigLocation(configLocationParam);
                }
                webContext.refresh();
                sctx.setAttribute(CONTEXT_ATTRIBUTE, (Object)BLUEPRINT_CONTEXT);
                sctx.setAttribute(BLUEPRINT_CONTEXT, (Object)webContext);
            }
            catch (Exception e) {
                sctx.setAttribute(BLUEPRINT_CONTEXT, (Object)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ldr);
            }
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
    }
}

