/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import ch.sourcepond.spring.web.blueprint.internal.BundleResourcePatternResolver;
import ch.sourcepond.spring.web.blueprint.internal.ResourceFinderClassLoader;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringValueResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.springframework.web.context.support.StandardServletEnvironment;

public final class BlueprintApplicationContext
implements WebApplicationContext,
ConfigurableBeanFactory,
ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintApplicationContext.class);
    static final String BLUEPRINT_CONTAINER_CONTAINER_HAS_BEEN_SHUTDOWN = "BlueprintContainer container has been shutdown";
    static final String[] EMPTY = new String[0];
    static final String OSGI_BLUEPRINT_CONTAINER_SYMBOLIC_NAME = "osgi.blueprint.container.symbolicname";
    static final String OSGI_BLUEPRINT_CONTAINER_VERSION = "osgi.blueprint.container.version";
    private final Instant startTime = Instant.now();
    private final ResourcePatternResolver resolver;
    private final ServletContext servletContext;
    private final Environment environment;
    private final BundleContext bundleContext;
    private final String filter;
    private boolean destroyed;
    private volatile MessageSource source;
    private volatile ClassLoader classLoader;
    private volatile ClassLoader tempClassLoader;
    private volatile BlueprintContainer container;
    private volatile Set<String> componentIds;

    public BlueprintApplicationContext(ServletContext servletContext, BundleContext bundleContext) {
        this.servletContext = servletContext;
        StandardServletEnvironment environment = new StandardServletEnvironment();
        environment.initPropertySources(servletContext, null);
        this.environment = environment;
        this.bundleContext = Objects.requireNonNull(bundleContext, "Bundle-Context is null");
        Bundle bundle = bundleContext.getBundle();
        this.filter = "(&(objectClass=" + BlueprintContainer.class.getName() + ")(" + OSGI_BLUEPRINT_CONTAINER_SYMBOLIC_NAME + "=" + bundle.getSymbolicName() + ")(" + OSGI_BLUEPRINT_CONTAINER_VERSION + "=" + bundle.getVersion() + "))";
        this.classLoader = ResourceFinderClassLoader.getBundleClassLoader(bundle);
        BundleResourcePatternResolver resolver = new BundleResourcePatternResolver((ResourcePatternResolver)new ServletContextResourcePatternResolver((ResourceLoader)this));
        resolver.setBundle(bundle);
        this.resolver = resolver;
    }

    private Bundle getBundle() {
        return this.bundleContext.getBundle();
    }

    public String getFilter() {
        return this.filter;
    }

    private BlueprintContainer findExistingBlueprintContainer() {
        BlueprintContainer container = null;
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences((String)null, this.filter);
            if (refs != null) {
                container = (BlueprintContainer)this.bundleContext.getService(refs[0]);
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlueprintContainer getContainer() {
        if (this.container == null) {
            BlueprintApplicationContext blueprintApplicationContext = this;
            synchronized (blueprintApplicationContext) {
                if (this.container == null) {
                    this.container = this.findExistingBlueprintContainer();
                    try {
                        while (this.container == null && !this.destroyed) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new BeanDefinitionStoreException("Wait for BlueprintContainer interrupted", (Throwable)e);
                    }
                    if (this.container == null) {
                        throw new BeanDefinitionStoreException(BLUEPRINT_CONTAINER_CONTAINER_HAS_BEEN_SHUTDOWN);
                    }
                }
            }
        }
        return this.container;
    }

    private synchronized void blueprintContainerRegistered(ServiceReference<?> pReference) {
        this.container = (BlueprintContainer)this.bundleContext.getService(pReference);
        this.notifyAll();
    }

    private synchronized void blueprintContainerUnregistered() {
        this.container = null;
        this.destroyed = true;
        this.notifyAll();
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 4: 
            case 8: {
                this.blueprintContainerUnregistered();
                break;
            }
            case 1: {
                this.blueprintContainerRegistered(serviceEvent.getServiceReference());
                break;
            }
        }
    }

    private Set<String> getFilteredComponentIds() {
        Set<String> ids = this.componentIds;
        if (ids == null) {
            BlueprintContainer container = this.getContainer();
            ids = new HashSet<String>(container.getComponentIds());
            ids.removeIf(id -> this.isIncompatible(container.getComponentMetadata(id)));
            this.componentIds = ids;
        }
        return ids;
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.getFilteredComponentIds().contains(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.getFilteredComponentIds().size();
    }

    public String[] getBeanDefinitionNames() {
        return this.getFilteredComponentIds().toArray(EMPTY);
    }

    public String[] getBeanNamesForType(ResolvableType type) {
        return this.getBeanNamesForType(type.getRawClass());
    }

    public String[] getBeanNamesForType(Class<?> type) {
        return this.getBeanNamesForType(type, false, false);
    }

    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        HashSet<String> beanNames = new HashSet<String>();
        for (String id : this.getFilteredComponentIds()) {
            try {
                Class<?> cl = this.findType(this.findMetadata(id));
                if (!type.isAssignableFrom(cl)) continue;
                beanNames.add(id);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return beanNames.toArray(EMPTY);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeansOfType(type, false, false);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        HashMap<String, T> beans = new HashMap<String, T>();
        for (String name : this.getBeanNamesForType(type)) {
            beans.put(name, this.getBean(name, type));
        }
        return beans;
    }

    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        return EMPTY;
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return Collections.emptyMap();
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        this.getBean(beanName);
        return null;
    }

    public Object getBean(String s) throws BeansException {
        try {
            return this.getContainer().getComponentInstance(s);
        }
        catch (NoSuchComponentException e) {
            NoSuchBeanDefinitionException nsbe = new NoSuchBeanDefinitionException(s);
            nsbe.initCause((Throwable)e);
            throw nsbe;
        }
    }

    public <T> T getBean(String s, Class<T> aClass) throws BeansException {
        Object instance = this.getBean(s);
        if (aClass != null && !aClass.isAssignableFrom(instance.getClass())) {
            throw new BeanNotOfRequiredTypeException(s, aClass, instance.getClass());
        }
        return (T)instance;
    }

    public <T> T getBean(Class<T> aClass) throws BeansException {
        Objects.requireNonNull(aClass, "Class is null");
        BlueprintContainer container = this.getContainer();
        Set<String> ids = this.getFilteredComponentIds();
        HashMap beans = new HashMap(ids.size());
        ids.forEach(id -> beans.put(id, this.getContainer().getComponentInstance(id)));
        Iterator it = beans.values().iterator();
        while (it.hasNext()) {
            if (aClass.isAssignableFrom(it.next().getClass())) continue;
            it.remove();
        }
        if (beans.isEmpty()) {
            throw new NoSuchBeanDefinitionException(aClass);
        }
        if (beans.size() > 1) {
            throw new NoUniqueBeanDefinitionException(aClass, beans.keySet());
        }
        return (T)beans.values().iterator().next();
    }

    public Object getBean(String s, Object ... objects) throws BeansException {
        return this.getBean(s);
    }

    public <T> T getBean(Class<T> aClass, Object ... objects) throws BeansException {
        return this.getBean(aClass);
    }

    public boolean containsBean(String s) {
        try {
            this.getContainer().getComponentInstance(s);
            return true;
        }
        catch (NoSuchComponentException e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean hasScope(String pScope, String s) throws NoSuchBeanDefinitionException {
        boolean singleton;
        try {
            ComponentMetadata m = this.getContainer().getComponentMetadata(s);
            singleton = m instanceof BeanMetadata && pScope.equals(((BeanMetadata)m).getScope());
        }
        catch (NoSuchComponentException e) {
            throw new NoSuchBeanDefinitionException(s);
        }
        return singleton;
    }

    public boolean isSingleton(String s) throws NoSuchBeanDefinitionException {
        return this.hasScope("singleton", s);
    }

    public boolean isPrototype(String s) throws NoSuchBeanDefinitionException {
        return this.hasScope("prototype", s);
    }

    public boolean isTypeMatch(String s, ResolvableType resolvableType) throws NoSuchBeanDefinitionException {
        return resolvableType.isAssignableFrom(this.getBean(s).getClass());
    }

    public boolean isTypeMatch(String s, Class<?> aClass) throws NoSuchBeanDefinitionException {
        return aClass.isAssignableFrom(this.getBean(s).getClass());
    }

    public Class<?> getType(String s) throws NoSuchBeanDefinitionException {
        try {
            return this.findType(this.findMetadata(s));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            NoSuchBeanDefinitionException ex = new NoSuchBeanDefinitionException(s);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private boolean isIncompatible(ComponentMetadata metadata) {
        return !(metadata instanceof BeanMetadata) && !(metadata instanceof ServiceReferenceMetadata);
    }

    private ComponentMetadata findMetadata(String id) {
        try {
            ComponentMetadata metadata = this.getContainer().getComponentMetadata(id);
            if (this.isIncompatible(metadata)) {
                throw new NoSuchComponentException("Actual metadata-class " + metadata.getClass() + " is not assignable from " + BeanMetadata.class.getName() + " or " + ServiceReferenceMetadata.class, id);
            }
            return metadata;
        }
        catch (NoSuchComponentException e) {
            NoSuchBeanDefinitionException nsbe = new NoSuchBeanDefinitionException(id);
            nsbe.initCause((Throwable)e);
            throw nsbe;
        }
    }

    private String getComponentId(Target target) {
        String componentId = target instanceof ComponentMetadata ? ((ComponentMetadata)target).getId() : ((RefMetadata)target).getComponentId();
        return componentId;
    }

    private Class<?> findType(ComponentMetadata metadata) throws ClassNotFoundException, NoSuchMethodException {
        assert (metadata != null) : "metadata cannot be null";
        Class<?> clazz = null;
        if (metadata instanceof BeanMetadata) {
            BeanMetadata beanMetadata = (BeanMetadata)metadata;
            String factoryMethodNameOrNull = beanMetadata.getFactoryMethod();
            String className = beanMetadata.getClassName();
            if (className == null) {
                if (factoryMethodNameOrNull == null) {
                    throw new IllegalStateException("Invalid metadata: class-name nor factory-method is provided! " + metadata);
                }
                Target factoryComponent = beanMetadata.getFactoryComponent();
                if (factoryComponent == null) {
                    throw new IllegalStateException("No class-name nor a factory component has been specified!");
                }
                ComponentMetadata factoryComponentMetadata = this.findMetadata(this.getComponentId(factoryComponent));
                Class<?> factoryComponentClass = this.findType(factoryComponentMetadata);
                clazz = factoryComponentClass.getMethod(factoryMethodNameOrNull, new Class[0]).getReturnType();
            } else {
                clazz = factoryMethodNameOrNull != null ? this.determineFactoryReturnType(beanMetadata) : this.loadClass(className);
            }
        } else if (metadata instanceof ServiceReferenceMetadata) {
            ServiceReferenceMetadata referenceMetadata = (ServiceReferenceMetadata)metadata;
            if (referenceMetadata.getInterface() != null) {
                clazz = this.loadClass(referenceMetadata.getInterface());
            }
        } else {
            throw new CannotLoadBeanClassException(this.bundleContext.getBundle().toString(), metadata.getId(), metadata.toString(), new ClassNotFoundException());
        }
        return clazz;
    }

    private Class<?> determineFactoryReturnType(BeanMetadata metadata) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> factoryClass = this.loadClass(metadata.getClassName());
        return factoryClass.getMethod(metadata.getFactoryMethod(), new Class[0]).getReturnType();
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.bundleContext.getBundle().loadClass(className);
    }

    public String[] getAliases(String s) {
        return EMPTY;
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) throws IllegalStateException {
        throw new IllegalStateException("Settings a parent BeanFactory is not supported");
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.classLoader = beanClassLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.classLoader;
    }

    public void setTempClassLoader(ClassLoader tempClassLoader) {
        this.tempClassLoader = tempClassLoader;
    }

    public ClassLoader getTempClassLoader() {
        return this.tempClassLoader;
    }

    public void setCacheBeanMetadata(boolean cacheBeanMetadata) {
        throw new UnsupportedOperationException();
    }

    public boolean isCacheBeanMetadata() {
        return false;
    }

    public void setBeanExpressionResolver(BeanExpressionResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public BeanExpressionResolver getBeanExpressionResolver() {
        throw new UnsupportedOperationException();
    }

    public void setConversionService(ConversionService conversionService) {
        throw new UnsupportedOperationException();
    }

    public ConversionService getConversionService() {
        return null;
    }

    public void addPropertyEditorRegistrar(PropertyEditorRegistrar registrar) {
        throw new UnsupportedOperationException();
    }

    public void registerCustomEditor(Class<?> requiredType, Class<? extends PropertyEditor> propertyEditorClass) {
        throw new UnsupportedOperationException();
    }

    public void copyRegisteredEditorsTo(PropertyEditorRegistry registry) {
        throw new UnsupportedOperationException();
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        throw new UnsupportedOperationException();
    }

    public TypeConverter getTypeConverter() {
        throw new UnsupportedOperationException();
    }

    public void addEmbeddedValueResolver(StringValueResolver valueResolver) {
        throw new UnsupportedOperationException();
    }

    public boolean hasEmbeddedValueResolver() {
        return false;
    }

    public String resolveEmbeddedValue(String value) {
        return value;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        throw new UnsupportedOperationException();
    }

    public int getBeanPostProcessorCount() {
        return 0;
    }

    public void registerScope(String scopeName, Scope scope) {
        throw new UnsupportedOperationException();
    }

    public String[] getRegisteredScopeNames() {
        return EMPTY;
    }

    public Scope getRegisteredScope(String scopeName) {
        return null;
    }

    public AccessControlContext getAccessControlContext() {
        return AccessController.getContext();
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        throw new UnsupportedOperationException();
    }

    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        throw new UnsupportedOperationException();
    }

    public void resolveAliases(StringValueResolver valueResolver) {
        throw new UnsupportedOperationException();
    }

    public BeanDefinition getMergedBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        return null;
    }

    public boolean isFactoryBean(String name) throws NoSuchBeanDefinitionException {
        return false;
    }

    public void setCurrentlyInCreation(String beanName, boolean inCreation) {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrentlyInCreation(String beanName) {
        return false;
    }

    public void registerDependentBean(String beanName, String dependentBeanName) {
        throw new UnsupportedOperationException();
    }

    public String[] getDependentBeans(String beanName) {
        return EMPTY;
    }

    public String[] getDependenciesForBean(String beanName) {
        return EMPTY;
    }

    public void destroyBean(String beanName, Object beanInstance) {
        throw new UnsupportedOperationException();
    }

    public void destroyScopedBean(String beanName) {
        throw new UnsupportedOperationException();
    }

    public void destroySingletons() {
    }

    public BeanFactory getParentBeanFactory() {
        return null;
    }

    public boolean containsLocalBean(String name) {
        return this.containsBean(name);
    }

    public void registerSingleton(String beanName, Object singletonObject) {
        throw new UnsupportedOperationException();
    }

    public Object getSingleton(String beanName) {
        return this.getBean(beanName);
    }

    public boolean containsSingleton(String beanName) {
        return this.getFilteredComponentIds().contains(beanName);
    }

    public String[] getSingletonNames() {
        return this.getFilteredComponentIds().toArray(new String[0]);
    }

    public int getSingletonCount() {
        return this.getFilteredComponentIds().size();
    }

    public Object getSingletonMutex() {
        return this;
    }

    public String getId() {
        return this.getBundle().getSymbolicName();
    }

    public String getApplicationName() {
        return "";
    }

    public String getDisplayName() {
        return this.getId();
    }

    public long getStartupDate() {
        return this.startTime.toEpochMilli();
    }

    public ApplicationContext getParent() {
        return null;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        throw new IllegalStateException("AutowireCapableBeanFactory not supported");
    }

    public void publishEvent(ApplicationEvent event) {
        LOG.debug("noop");
    }

    public void publishEvent(Object event) {
        LOG.debug("noop");
    }

    private MessageSource getMessageSource() {
        MessageSource source = this.source;
        if (source == null) {
            try {
                source = this.getBean("messageSource", MessageSource.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                source = new DelegatingMessageSource();
            }
            this.source = source;
        }
        return source;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resolver.getResources(locationPattern);
    }

    public Resource getResource(String location) {
        return this.resolver.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return this.getBeanClassLoader();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

