/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import ch.sourcepond.spring.web.blueprint.internal.BundleSpaceResolver;
import ch.sourcepond.spring.web.blueprint.internal.ClasspathResolver;
import ch.sourcepond.spring.web.blueprint.internal.InternalResolver;
import ch.sourcepond.spring.web.blueprint.internal.ResourceFinderClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class BundleResourcePatternResolver
implements ResourcePatternResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BundleResourcePatternResolver.class);
    static final String CLASSPATH_URL_PREFIX = "classpath:";
    static final String CLASSPATHS_URL_PREFIX = "classpath*:";
    static final String OSGI_BUNDLE_URL_PREFIX = "osgibundle:";
    static final String PREFIX_UNSPECIFIED = "";
    static final char PROTOCOL_SEPARATOR = ':';
    private final Map<String, InternalResolver> accessors = new HashMap<String, InternalResolver>();
    private final ResourcePatternResolver patternResolver;
    private volatile Bundle bundle;

    public BundleResourcePatternResolver(ResourcePatternResolver patternResolver) {
        this(patternResolver, new ClasspathResolver((PathMatcher)new AntPathMatcher()), new BundleSpaceResolver((PathMatcher)new AntPathMatcher()));
    }

    BundleResourcePatternResolver(ResourcePatternResolver patternResolver, InternalResolver classpathResolver, InternalResolver bundlespaceResolver) {
        this.patternResolver = patternResolver;
        this.accessors.put(CLASSPATH_URL_PREFIX, classpathResolver);
        this.accessors.put(CLASSPATHS_URL_PREFIX, classpathResolver);
        this.accessors.put(OSGI_BUNDLE_URL_PREFIX, bundlespaceResolver);
        this.accessors.put(PREFIX_UNSPECIFIED, bundlespaceResolver);
    }

    public void setBundle(Bundle bundle) {
        this.bundle = Objects.requireNonNull(bundle, "Bundle cannot be null");
    }

    private InternalResolver getResolverOrNull(String pProtocolPrefix) {
        return this.accessors.get(pProtocolPrefix);
    }

    private String extractProtocol(String pLocationPattern) {
        int protocolSeparatorIdx = pLocationPattern.indexOf(58) + 1;
        return pLocationPattern.substring(0, protocolSeparatorIdx);
    }

    public final Resource getResource(String path) {
        Resource foundResource = null;
        if (this.bundle == null) {
            LOG.warn("No resource determined for {} because no bundle is set", (Object)path);
        } else {
            String protocol = this.extractProtocol(path);
            String normalizedLocationPattern = path.substring(protocol.length());
            InternalResolver resolver = this.getResolverOrNull(protocol);
            if (resolver == null) {
                foundResource = this.patternResolver.getResource(path);
            } else {
                URL resourceUrl = resolver.resolveResource(this.bundle, normalizedLocationPattern);
                if (resourceUrl != null) {
                    foundResource = new UrlResource(resourceUrl);
                }
            }
            LOG.debug("Resource for protocol {} and normalized location pattern {} : {}", new Object[]{protocol, normalizedLocationPattern, foundResource});
        }
        return foundResource;
    }

    public final ClassLoader getClassLoader() {
        if (this.bundle == null) {
            LOG.warn("Using system classloader because no bundle is set");
            return ClassLoader.getSystemClassLoader();
        }
        return ResourceFinderClassLoader.getBundleClassLoader(this.bundle);
    }

    public final Resource[] getResources(String pattern) throws IOException {
        Resource[] foundResources;
        if (this.bundle == null) {
            foundResources = new Resource[]{};
            LOG.warn("No resources determined for {} because no bundle is set", (Object)pattern);
        } else {
            String protocol = this.extractProtocol(pattern);
            String normalizedPathPattern = pattern.substring(protocol.length());
            InternalResolver resolver = this.getResolverOrNull(protocol);
            if (resolver == null) {
                foundResources = this.patternResolver.getResources(pattern);
            } else {
                Collection<URL> foundResourceUrls = resolver.resolveResources(this.bundle, normalizedPathPattern);
                if (foundResourceUrls.isEmpty()) {
                    foundResources = this.patternResolver.getResources(pattern);
                } else {
                    foundResources = new Resource[foundResourceUrls.size()];
                    int i = 0;
                    for (URL foundResourceUrl : foundResourceUrls) {
                        foundResources[i++] = new UrlResource(foundResourceUrl);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resources for protocol {} and normalized location pattern {} : {}", new Object[]{protocol, normalizedPathPattern, Arrays.asList(foundResources)});
            }
        }
        return foundResources;
    }
}

