/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import ch.sourcepond.spring.web.blueprint.internal.InternalResolver;
import java.net.URL;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PathMatcher;

class ClasspathResolver
extends InternalResolver<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathResolver.class);

    ClasspathResolver(PathMatcher matcher) {
        super(matcher);
    }

    private BundleWiring bundleWiring(Bundle bundle) {
        return (BundleWiring)bundle.adapt(BundleWiring.class);
    }

    @Override
    protected Collection<String> listAllResources(Bundle bundle) {
        BundleWiring wiring = this.bundleWiring(bundle);
        LOG.debug("Bundle state of {} is {}, wiring is in use: {}", new Object[]{bundle.getSymbolicName(), bundle.getState(), wiring.isInUse()});
        return this.bundleWiring(bundle).listResources("/", "*", 1);
    }

    @Override
    protected URL doResolveResource(Bundle bundle, String path) {
        return this.bundleWiring(bundle).getClassLoader().getResource(path);
    }

    @Override
    protected String toPath(String path, String pattern) {
        return path;
    }
}

