/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.spring.web.blueprint.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PathMatcher;

abstract class InternalResolver<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InternalResolver.class);
    private final PathMatcher matcher;

    InternalResolver(PathMatcher matcher) {
        this.matcher = matcher;
    }

    abstract Collection<T> listAllResources(Bundle var1);

    abstract URL doResolveResource(Bundle var1, String var2);

    final URL resolveResource(Bundle bundle, String path) {
        URL resolvedResource = this.doResolveResource(bundle, path);
        if (resolvedResource == null) {
            throw new IllegalStateException(path + " could not be resolved to an URL object!");
        }
        return resolvedResource;
    }

    abstract String toPath(T var1, String var2);

    final Collection<URL> resolveResources(Bundle bundle, String pattern) throws IOException {
        LinkedList<URL> foundResources = new LinkedList<URL>();
        Collection<T> resourcePaths = this.listAllResources(bundle);
        LOG.debug("Following resources listed for {} before filtering: {}", (Object)bundle.getSymbolicName(), resourcePaths);
        if (resourcePaths != null && !resourcePaths.isEmpty()) {
            for (T resourcePath : resourcePaths) {
                String resourcePathAsString = this.toPath(resourcePath, pattern);
                if (this.matcher.match(pattern, resourcePathAsString) && !resourcePathAsString.endsWith("/")) {
                    foundResources.add(this.resolveResource(bundle, resourcePathAsString));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignored {} from {} because it does not match pattern {}", new Object[]{resourcePathAsString, bundle.getSymbolicName(), pattern});
            }
        }
        return foundResources;
    }
}

