/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.testing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import java.util.UUID;
import org.junit.Assert;

public class BundleWriter {
    private static final File BUNDLES_FILE = new File(System.getProperty("java.io.tmpdir"), "ch.sourcepond.testing.bundles.properties");
    private static Properties PROPS = BundleWriter.loadProperties();

    private static Properties loadProperties() {
        try {
            if (!BUNDLES_FILE.exists()) {
                BUNDLES_FILE.createNewFile();
                BUNDLES_FILE.deleteOnExit();
            }
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(BUNDLES_FILE);){
                props.load(in);
            }
            return props;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeBundle(String pKey, InputStream pIn) {
        try {
            File f = File.createTempFile(UUID.randomUUID().toString(), ".jar");
            f.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(f);){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = pIn.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
            PROPS.setProperty(pKey, f.toURI().toURL().toString());
            out = new FileOutputStream(BUNDLES_FILE);
            var4_5 = null;
            try {
                PROPS.store(out, null);
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var4_5 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getLocation(String pKey) {
        String location = PROPS.getProperty(pKey);
        Assert.assertNotNull((String)String.format("No bundle writen for key %s", pKey), (Object)location);
        return location;
    }
}

