/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.testing;

import ch.sourcepond.testing.StubServiceFactory;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class StubServiceActivator
implements BundleActivator {
    static final String SERVICE_PROPERTIES = "service.properties";
    static final String SERVICE_INTERFACE = "serviceInterface";
    static final String IMPL_CLASS = "implClass";
    private Class<?> serviceInterface;
    private Class<?> implClass;
    private StubServiceFactory factory;
    private Object service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        InputStream in = this.getClass().getResourceAsStream(String.format("/%s", SERVICE_PROPERTIES));
        if (in != null) {
            Properties tmp = new Properties();
            try {
                tmp.load(in);
            }
            finally {
                in.close();
            }
            Enumeration<?> e = tmp.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                serviceProperties.put(name, tmp.getProperty(name));
            }
        }
        if (StubServiceFactory.class.isAssignableFrom(this.implClass)) {
            this.factory = (StubServiceFactory)this.implClass.newInstance();
            this.service = this.factory.create();
        } else {
            this.service = this.implClass.newInstance();
        }
        context.registerService(this.serviceInterface, this.service, serviceProperties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.factory != null && this.service != null) {
            this.factory.destroy(this.service);
        }
    }
}

