/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.testing;

import ch.sourcepond.testing.StubServiceActivator;
import ch.sourcepond.testing.StubServiceFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import org.junit.Assert;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;

public class ServiceStubber<T> {
    private static final String ENHANCED_ACTIVATOR_CLASS_NAME = "ch.sourcepond.$enhanced." + StubServiceActivator.class.getSimpleName();
    private Class<? extends T> implementation;
    private Class<? extends StubServiceFactory<T>> factory;
    private final List<Class<?>> classes = new LinkedList();
    private final Class<T> serviceInterface;
    private final Properties properties = new Properties();

    ServiceStubber(Class<T> pServiceInterface) {
        this.serviceInterface = pServiceInterface;
    }

    public ServiceStubber<T> withImpl(Class<? extends T> pImplementation) {
        Assert.assertNotNull((String)"Implementation class should not be null!", pImplementation);
        this.implementation = pImplementation;
        return this;
    }

    public ServiceStubber<T> withFactory(Class<? extends StubServiceFactory<T>> pFactory) {
        Assert.assertNotNull((String)"Factory class should not be null!", pFactory);
        this.factory = pFactory;
        return this;
    }

    public ServiceStubber<T> addClass(Class<?> pClass) {
        this.classes.add(pClass);
        return this;
    }

    public ServiceStubber<T> addProperty(String pPropertyName, String pValue) {
        this.properties.setProperty(pPropertyName, pValue);
        return this;
    }

    static Option buildBundle(TinyBundle pBundle) throws Exception {
        try (InputStream in = pBundle.build(TinyBundles.withBnd());){
            File bundle = File.createTempFile("test-bundle.", ".jar");
            bundle.deleteOnExit();
            Files.copy(in, bundle.toPath(), StandardCopyOption.REPLACE_EXISTING);
            UrlProvisionOption urlProvisionOption = new UrlProvisionOption(bundle.toURI().toURL().toExternalForm());
            return urlProvisionOption;
        }
    }

    private static void initField(CtClass activatorCtClass, String pName, Class<?> pServiceInterface) throws Exception {
        CtField field = activatorCtClass.getField(pName);
        activatorCtClass.removeField(field);
        activatorCtClass.addField(field, CtField.Initializer.byExpr((String)String.format("%s.class", pServiceInterface.getName())));
    }

    private Class<?> enhanceActivatorClass(Class<?> pImplClass) throws Exception {
        ClassPool pool = ClassPool.getDefault();
        CtClass activatorCtClass = pool.get(StubServiceActivator.class.getName());
        if (!activatorCtClass.isFrozen()) {
            activatorCtClass.setName(ENHANCED_ACTIVATOR_CLASS_NAME);
            ServiceStubber.initField(activatorCtClass, "serviceInterface", this.serviceInterface);
            ServiceStubber.initField(activatorCtClass, "implClass", pImplClass);
            activatorCtClass.writeFile("target/test-classes");
        }
        return this.getClass().getClassLoader().loadClass(ENHANCED_ACTIVATOR_CLASS_NAME);
    }

    public Option build() throws Exception {
        Class<?> impl = this.determineImplClass();
        TinyBundle bundle = TinyBundles.bundle();
        bundle.add(impl);
        if (!this.classes.isEmpty()) {
            for (Class<?> cl : this.classes) {
                bundle.add(cl);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.properties.store(out, "Service properties");
        Class<?> enhancedActivatorClass = this.enhanceActivatorClass(impl);
        return CoreOptions.composite((Option[])new Option[]{ServiceStubber.buildBundle(bundle.add(impl).add(enhancedActivatorClass).set("Bundle-Activator", enhancedActivatorClass.getName()).add(String.format("/%s", "service.properties"), (InputStream)new ByteArrayInputStream(out.toByteArray()))), CoreOptions.mavenBundle((String)"ch.sourcepond.testing", (String)"bundle-test-support").versionAsInProject(), CoreOptions.mavenBundle((String)"org.ops4j.pax.tinybundles", (String)"tinybundles").versionAsInProject(), CoreOptions.mavenBundle((String)"biz.aQute.bnd", (String)"bndlib").versionAsInProject(), CoreOptions.mavenBundle((String)"org.javassist", (String)"javassist").versionAsInProject()});
    }

    private Class<?> determineImplClass() {
        Assert.assertFalse((String)String.format("Either the service implementation class or an implementation of %s must be specified but not both!", StubServiceFactory.class.getName()), (this.implementation != null && this.factory != null ? 1 : 0) != 0);
        Class<? extends StubServiceFactory<T>> impl = this.implementation == null ? this.factory : this.implementation;
        Assert.assertNotNull((String)"Neither an implementation nor a factory have been specified. Use either withImpl() or withFactory()", impl);
        return impl;
    }
}

