/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.testing;

import ch.sourcepond.testing.ServiceStubber;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.KarafFeaturesOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;

public class OptionsHelper {
    public static Option karafContainer(KarafFeaturesOption ... pFeaturesToBeInstalled) {
        return OptionsHelper.karafContainer(FileSystems.getDefault().getPath(System.getProperty("user.dir"), "target", "exam"), pFeaturesToBeInstalled);
    }

    public static Option karafContainer(Path pUnpackDir, KarafFeaturesOption ... pFeaturesToBeInstalled) {
        MavenArtifactUrlReference karafUrl = CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").versionAsInProject().type("tar.gz");
        return CoreOptions.composite((Option[])new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)karafUrl).unpackDirectory(pUnpackDir.toFile()).useDeployFolder(false).runEmbedded(true), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId("org.apache.karaf.features").artifactId("standard").classifier("features").type("xml").versionAsInProject(), (String[])new String[]{"scr", "config"}), CoreOptions.composite((Option[])pFeaturesToBeInstalled), KarafDistributionOption.keepRuntimeFolder()});
    }

    public static Option provisionBundlesFromUserDir(String ... pPath) {
        LinkedList<String> urls = new LinkedList<String>();
        Path dir = FileSystems.getDefault().getPath(System.getProperty("user.dir"), new String[0]);
        for (String pathElement : pPath) {
            dir = dir.resolve(pathElement);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, entry -> entry.getFileName().toString().endsWith(".jar"));){
            for (Path jar : stream) {
                urls.add(jar.toUri().toURL().toString());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return CoreOptions.provision((String[])urls.toArray(new String[0]));
    }

    public static Option defaultOptions(String pExaminee, String ... pDependencyComponent) {
        return CoreOptions.composite((Option[])new Option[]{OptionsHelper.examineeOption(pExaminee), OptionsHelper.dependenciesOption(pDependencyComponent), CoreOptions.mavenBundle((String)"com.google.guava", (String)"guava").versionAsInProject(), CoreOptions.mavenBundle((String)"org.apache.commons", (String)"commons-lang3").versionAsInProject(), CoreOptions.mavenBundle((String)"org.objenesis", (String)"objenesis").versionAsInProject(), CoreOptions.mavenBundle((String)"org.mockito", (String)"mockito-core").versionAsInProject(), CoreOptions.mavenBundle((String)"net.bytebuddy", (String)"byte-buddy").versionAsInProject(), CoreOptions.frameworkProperty((String)"felix.bootdelegation.implicit").value((Object)"false"), CoreOptions.junitBundles(), CoreOptions.systemProperty((String)"logback.configurationFile").value("")});
    }

    public static Option mockitoBundles() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.mockito").artifactId("mockito-core").versionAsInProject(), CoreOptions.mavenBundle().groupId("net.bytebuddy").artifactId("byte-buddy").versionAsInProject(), CoreOptions.mavenBundle().groupId("net.bytebuddy").artifactId("byte-buddy-agent").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.objenesis").artifactId("objenesis").versionAsInProject()});
    }

    public static Option tinyBundles() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.ops4j.pax.tinybundles").artifactId("tinybundles").versionAsInProject(), CoreOptions.mavenBundle().groupId("biz.aQute.bnd").artifactId("biz.aQute.bndlib").versionAsInProject()});
    }

    public static Option blueprintBundles() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle((String)"org.apache.aries", (String)"org.apache.aries.util").versionAsInProject(), CoreOptions.mavenBundle((String)"org.apache.aries.proxy", (String)"org.apache.aries.proxy.api").versionAsInProject(), CoreOptions.mavenBundle((String)"org.apache.aries.proxy", (String)"org.apache.aries.proxy.impl").versionAsInProject(), CoreOptions.mavenBundle((String)"org.apache.aries.blueprint", (String)"org.apache.aries.blueprint.core").versionAsInProject()});
    }

    public static <T> ServiceStubber<T> stubService(Class<T> pServiceInterface) {
        return new ServiceStubber<T>(pServiceInterface);
    }

    private static Option dependenciesOption(String[] pDependencyComponent) {
        Option[] option = new Option[pDependencyComponent.length];
        for (int i = 0; i < option.length; ++i) {
            option[i] = OptionsHelper.componentOption(pDependencyComponent[i]);
        }
        return CoreOptions.composite((Option[])option);
    }

    private static Option examineeOption(String pComponentName) {
        String[] coordinates = OptionsHelper.coordinates(pComponentName);
        return CoreOptions.composite((Option[])new Option[]{OptionsHelper.componentOption(pComponentName), CoreOptions.wrappedBundle((UrlReference)CoreOptions.maven((String)coordinates[0], (String)(coordinates[1] + "-impl")).classifier("tests"))});
    }

    private static Option componentOption(String pComponentName) {
        String[] coordinates = OptionsHelper.coordinates(pComponentName);
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle((String)coordinates[0], (String)(coordinates[1] + "-api")).versionAsInProject(), CoreOptions.mavenBundle((String)coordinates[0], (String)(coordinates[1] + "-impl")).versionAsInProject()});
    }

    private static String[] coordinates(String pComponentName) {
        String[] coordinates;
        coordinates = new String[]{pComponentName.substring(0, pComponentName.lastIndexOf(46)), pComponentName.substring(coordinates[0].length() + 1)};
        return coordinates;
    }
}

