/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.mdcwrapper.impl;

import ch.sourcepond.utils.mdcwrapper.api.MdcWrapper;
import ch.sourcepond.utils.mdcwrapper.impl.DefaultTestExecutorService;
import ch.sourcepond.utils.mdcwrapper.impl.TestExecutorService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public abstract class MdcWrapperTest {
    private final MdcRunnable runnable = new MdcRunnable();
    private final MdcCallback callable = new MdcCallback();
    private final Runnable[] runnables = new Runnable[]{this.runnable};
    private final Collection<Runnable> runnableCollection = Arrays.asList(this.runnable);
    private final Callable<?>[] callables = new Callable[]{this.callable};
    private final Collection<Callable<?>> callableCollection = Arrays.asList(this.callable);
    private final TestExecutorService service = new DefaultTestExecutorService(1);
    private MdcWrapper wrapper;
    private TestExecutorService proxy;

    protected abstract MdcWrapper getWrapper();

    @Before
    public void setup() throws Exception {
        this.wrapper = this.getWrapper();
        this.proxy = (TestExecutorService)this.wrapper.wrap((Executor)this.service, TestExecutorService.class);
        this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        }).get();
    }

    @After
    public void tearDown() throws InterruptedException {
        this.service.shutdown();
        this.service.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void verifyExecutorIsNull() {
        this.wrapper.wrap(null, TestExecutorService.class);
    }

    @Test(expected=NullPointerException.class)
    public void verifyExecutorInterfaceIsNull() {
        this.wrapper.wrap((Executor)this.service, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyClassSpecifiedIsNotAnInterface() {
        this.wrapper.wrap((Executor)((DefaultTestExecutorService)this.service), DefaultTestExecutorService.class);
    }

    @Test(expected=NullPointerException.class)
    public void verifyWrapNullThreadFactory() {
        this.wrapper.wrap((ThreadFactory)null);
    }

    @Test
    public void verifyWrapThreadFactory() throws InterruptedException {
        ThreadFactory factory = Executors.defaultThreadFactory();
        ThreadFactory wrappedFactory = this.wrapper.wrap(factory);
        MDC.put((String)"mdcKey", (String)"mdcValue");
        Thread th = wrappedFactory.newThread(this.runnable);
        th.start();
        th.join();
        this.runnable.verifyMdcValue();
    }

    @Test(expected=NullPointerException.class)
    public void verifyWrapNullRunnable() {
        this.wrapper.wrap((Runnable)null);
    }

    @Test
    public void verifyWrapRunnable() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.service.execute(this.wrapper.wrap((Runnable)this.runnable));
        this.runnable.verifyMdcValue();
    }

    @Test(expected=NullPointerException.class)
    public void verifyWrapNullCallable() {
        this.wrapper.wrap((Callable)null);
    }

    @Test
    public void verifyWrapCallable() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.service.submit(this.wrapper.wrap((Callable)this.callable));
        this.callable.verifyMdcValue();
    }

    @Test
    public void verifyWrapNonMdcAwareProxy() throws Exception {
        ExecutorService executor = (ExecutorService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ExecutorService.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
        Assert.assertNotSame((Object)executor, (Object)this.wrapper.wrap((Executor)executor, ExecutorService.class));
    }

    @Test
    public void verifyDoNotWrapMdcAwareExecutorProxy() {
        Assert.assertSame((Object)this.proxy, (Object)this.wrapper.wrap((Executor)this.proxy, TestExecutorService.class));
    }

    @Test
    public void verifyDoNotWrapMdcAwareThreadFactoryProxy() {
        ThreadFactory tf = this.wrapper.wrap(Executors.defaultThreadFactory());
        Assert.assertSame((Object)tf, (Object)this.wrapper.wrap(tf));
    }

    @Test
    public void verifyDoNotWrapMdcAwareRunnable() {
        Runnable r = this.wrapper.wrap((Runnable)this.runnable);
        Assert.assertSame((Object)r, (Object)this.wrapper.wrap(r));
    }

    @Test
    public void verifyDoNotWrapMdcAwareCallable() {
        Callable c = this.wrapper.wrap((Callable)this.callable);
        Assert.assertSame((Object)c, (Object)this.wrapper.wrap(c));
    }

    @Test
    public void verifyExecutorSingleRunnable() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.proxy.execute(this.runnable);
        this.runnable.verifyMdcValue();
    }

    @Test
    public void verifyExecutorSingleCallable() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.proxy.submit(this.callable);
        this.callable.verifyMdcValue();
    }

    @Test
    public void verifyExecutorCallableCollection() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.proxy.executeAllCallables(this.callableCollection);
        this.callable.verifyMdcValue();
    }

    @Test
    public void verifyExecutorCallableArray() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.proxy.executeAllCallables(this.callables);
        this.callable.verifyMdcValue();
    }

    @Test
    public void verifyExecutorRunnableCollection() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.proxy.executeAllRunnables(this.runnableCollection);
        this.runnable.verifyMdcValue();
    }

    @Test
    public void verifyExecutorRunnableArray() throws InterruptedException {
        MDC.put((String)"mdcKey", (String)"mdcValue");
        this.proxy.executeAllRunnables(this.runnables);
        this.runnable.verifyMdcValue();
    }

    private static class MdcCallback
    extends MdcTest
    implements Callable<Object> {
        private MdcCallback() {
        }

        @Override
        public Object call() throws Exception {
            this.setMdcValue();
            return null;
        }
    }

    private static class MdcRunnable
    extends MdcTest
    implements Runnable {
        private MdcRunnable() {
        }

        @Override
        public void run() {
            this.setMdcValue();
        }
    }

    private static class MdcTest {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private String mdcValue;

        private MdcTest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setMdcValue() {
            this.lock.lock();
            try {
                this.mdcValue = MDC.get((String)"mdcKey");
            }
            finally {
                this.condition.signalAll();
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyMdcValue() throws InterruptedException {
            this.lock.lock();
            try {
                int count = 5;
                while (this.mdcValue == null && count-- > 0) {
                    this.condition.await(100L, TimeUnit.MILLISECONDS);
                }
                Assert.assertEquals((Object)"mdcValue", (Object)this.mdcValue);
            }
            finally {
                MDC.clear();
                this.lock.unlock();
            }
        }
    }
}

