/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.mdcwrapper.impl;

import ch.sourcepond.utils.mdcwrapper.impl.MdcAwareCallable;
import ch.sourcepond.utils.mdcwrapper.impl.MdcAwareRunnable;
import ch.sourcepond.utils.mdcwrapper.impl.TestExecutorService;
import ch.sourcepond.utils.mdcwrapper.impl.WrapInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;

public class WrapInvocationHandlerTest {
    private final TestExecutorService executor = (TestExecutorService)Mockito.mock(TestExecutorService.class);
    private final Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
    private final Runnable secondRunnable = (Runnable)Mockito.mock(Runnable.class);
    private final Callable<?> callable = (Callable)Mockito.mock(Callable.class);
    private final Callable<?> secondCallable = (Callable)Mockito.mock(Callable.class);
    private TestExecutorService proxy;

    @Before
    public void setup() throws Exception {
        this.proxy = (TestExecutorService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TestExecutorService.class}, (InvocationHandler)new WrapInvocationHandler((Object)this.executor));
    }

    @Test
    public void verifyNullArg() {
        this.proxy.execute(null);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).execute(null);
    }

    @Test
    public void verifyDoNotWrapObject() {
        Object ob = new Object();
        this.proxy.unwrapped(ob);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).unwrapped(ob);
    }

    @Test
    public void verifyNoArgMethod() {
        this.proxy.isShutdown();
        ((TestExecutorService)Mockito.verify((Object)this.executor)).isShutdown();
    }

    @Test
    public void verifyWrapRunnable() {
        this.proxy.execute(this.runnable);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).execute((Runnable)Mockito.argThat(new TypeMatcher(MdcAwareRunnable.class)));
    }

    @Test
    public void verifyWrapCallable() {
        this.proxy.submit(this.callable);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).submit((Callable)Mockito.argThat(new TypeMatcher(MdcAwareCallable.class)));
    }

    @Test
    public void verifyWrapEmptyCollection() {
        ArrayList empty = new ArrayList();
        this.proxy.executeAllRunnables(empty);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).executeAllRunnables(empty);
    }

    @Test
    public void verifyDoNotWrapIncompatibleCollection() {
        List<Object> unwrapped = Arrays.asList(new Object());
        this.proxy.unwrappedCollection(unwrapped);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).unwrappedCollection(unwrapped);
    }

    @Test
    public void verifyWrapRunnableCollection() {
        List<Runnable> collection = Arrays.asList(this.runnable, this.secondRunnable);
        this.proxy.executeAllRunnables(collection);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).executeAllRunnables((Collection)Mockito.argThat(new CollectionMatcher(MdcAwareRunnable.class)));
    }

    @Test
    public void verifyWrapCallableCollection() {
        List<Callable<?>> collection = Arrays.asList(this.callable, this.secondCallable);
        this.proxy.executeAllCallables(collection);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).executeAllCallables((Collection)Mockito.argThat(new CollectionMatcher(MdcAwareCallable.class)));
    }

    @Test
    public void verifyWrapEmptyArray() {
        Runnable[] empty = new Runnable[]{};
        this.proxy.executeAllRunnables(empty);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).executeAllRunnables(empty);
    }

    @Test
    public void verifyDoNotWrapIncompatibleArray() {
        Object[] unwrapped = new Object[]{new Object()};
        this.proxy.unwrappedArray(unwrapped);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).unwrappedArray(unwrapped);
    }

    @Test
    public void verifyWrapRunnableArray() {
        Runnable[] array = new Runnable[]{this.runnable, this.secondRunnable};
        this.proxy.executeAllRunnables(array);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).executeAllRunnables(array);
        Assert.assertEquals(MdcAwareRunnable.class, array[0].getClass());
        Assert.assertEquals(MdcAwareRunnable.class, array[1].getClass());
    }

    @Test
    public void verifyWrapCallableArray() {
        Callable[] array = new Callable[]{this.callable, this.secondCallable};
        this.proxy.executeAllCallables(array);
        ((TestExecutorService)Mockito.verify((Object)this.executor)).executeAllCallables(array);
        Assert.assertEquals(MdcAwareCallable.class, array[0].getClass());
        Assert.assertEquals(MdcAwareCallable.class, array[1].getClass());
    }

    @Test
    public void verifyThrowTargetException() throws Exception {
        RejectedExecutionException expected = new RejectedExecutionException();
        ((TestExecutorService)Mockito.doThrow((Throwable)expected).when((Object)this.executor)).execute((Runnable)Mockito.argThat(new TypeMatcher(MdcAwareRunnable.class)));
        try {
            this.proxy.execute(this.runnable);
            Assert.fail((String)"Exception expected");
        }
        catch (RejectedExecutionException e) {
            Assert.assertSame((Object)expected, (Object)e);
        }
    }

    private class CollectionMatcher<T extends Collection<?>>
    extends TypeMatcher<T> {
        CollectionMatcher(Class<?> pMdcClass) {
            super(pMdcClass);
        }

        @Override
        public boolean matches(Object item) {
            Collection arg = (Collection)item;
            Iterator it = arg.iterator();
            return arg.size() == 2 && super.matches(it.next()) && super.matches(it.next());
        }
    }

    private class TypeMatcher<T>
    implements ArgumentMatcher<T> {
        private final Class<?> mdcClass;

        TypeMatcher(Class<?> pMdcClass) {
            this.mdcClass = pMdcClass;
        }

        public boolean matches(Object item) {
            return this.mdcClass.equals(item.getClass());
        }

        public String toString() {
            return this.mdcClass.getName();
        }
    }
}

