/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.mdcwrapper.impl.example;

import ch.sourcepond.utils.mdcwrapper.api.MdcWrapper;
import ch.sourcepond.utils.mdcwrapper.impl.DefaultMdcWrapper;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Examples {
    private final MdcWrapper wrapper = new DefaultMdcWrapper();

    public void getInstanceNoDependencyInjection() {
        DefaultMdcWrapper wrapper = new DefaultMdcWrapper();
    }

    public void getInstanceFromBundleContext(BundleContext ctx) {
        ServiceTracker tracker = new ServiceTracker(ctx, MdcWrapper.class, null);
        tracker.open();
        MdcWrapper wrapper = (MdcWrapper)tracker.getService();
    }

    public void wrapExecutor() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(10);
        ScheduledExecutorService mdcAwareExecutor = (ScheduledExecutorService)this.wrapper.wrap((Executor)executor, ScheduledExecutorService.class);
    }

    public void wrapThreadFactory() {
        ThreadFactory factory = Executors.defaultThreadFactory();
        ThreadFactory mdcAwareFactory = this.wrapper.wrap(factory);
    }

    public void wrapRunnable() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
            }
        };
        Runnable mdcAwareTask = this.wrapper.wrap(task);
    }

    public void wrapCallable() {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        };
        Callable mdcAwareTask = this.wrapper.wrap((Callable)task);
    }
}

