/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.mdcwrapper.impl;

import ch.sourcepond.utils.mdcwrapper.api.MdcWrapper;
import ch.sourcepond.utils.mdcwrapper.impl.MdcAwareCallable;
import ch.sourcepond.utils.mdcwrapper.impl.MdcAwareRunnable;
import ch.sourcepond.utils.mdcwrapper.impl.WrapInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.Validate;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class DefaultMdcWrapper
implements BundleActivator,
MdcWrapper {
    private <T> T createProxyIfNecessary(T pToBeWrapped, ClassLoader pLoader, Class<T> pInterface) {
        Class<?> cl = pToBeWrapped.getClass();
        if (Proxy.isProxyClass(cl) && WrapInvocationHandler.class.equals(Proxy.getInvocationHandler(pToBeWrapped).getClass())) {
            return pToBeWrapped;
        }
        return (T)Proxy.newProxyInstance(pLoader, new Class[]{pInterface}, (InvocationHandler)new WrapInvocationHandler(pToBeWrapped));
    }

    public <T extends Executor> T wrap(T pExecutor, Class<T> pInterface) {
        Validate.notNull(pExecutor, (String)"Executor to wrapped is null!", (Object[])new Object[0]);
        Validate.notNull(pInterface, (String)"Executor interface is null!", (Object[])new Object[0]);
        Validate.isTrue((boolean)pInterface.isInterface(), (String)"Class specified is not an interface!", (Object[])new Object[0]);
        return this.createProxyIfNecessary(pExecutor, pInterface.getClassLoader(), pInterface);
    }

    public Runnable wrap(Runnable pRunnable) {
        Validate.notNull((Object)pRunnable, (String)"Runnable to be wrapped is null!", (Object[])new Object[0]);
        if (MdcAwareRunnable.class.equals(pRunnable.getClass())) {
            return pRunnable;
        }
        return new MdcAwareRunnable(pRunnable);
    }

    public <V> Callable<V> wrap(Callable<V> pCallable) {
        Validate.notNull(pCallable, (String)"Callable to be wrapped is null!", (Object[])new Object[0]);
        if (MdcAwareCallable.class.equals(pCallable.getClass())) {
            return pCallable;
        }
        return new MdcAwareCallable<V>(pCallable);
    }

    public ThreadFactory wrap(ThreadFactory pThreadFactory) {
        Validate.notNull((Object)pThreadFactory, (String)"ThreadFactory to be wrapped is null!", (Object[])new Object[0]);
        return this.createProxyIfNecessary(pThreadFactory, pThreadFactory.getClass().getClassLoader(), ThreadFactory.class);
    }

    public void start(BundleContext context) throws Exception {
        context.registerService(MdcWrapper.class, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

