/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.mdcwrapper.impl;

import ch.sourcepond.utils.mdcwrapper.impl.MdcAwareCallable;
import ch.sourcepond.utils.mdcwrapper.impl.MdcAwareRunnable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;

final class WrapInvocationHandler
implements InvocationHandler {
    private final Object delegate;

    WrapInvocationHandler(Object pDelegate) {
        this.delegate = pDelegate;
    }

    private Object wrapIfNecessary(Object pArg) {
        Object rc = pArg;
        if (pArg instanceof Runnable) {
            rc = new MdcAwareRunnable((Runnable)((Object)pArg));
        } else if (pArg instanceof Callable) {
            rc = new MdcAwareCallable(pArg);
        } else if (pArg instanceof Collection) {
            Collection cl = (Collection)((Object)pArg);
            rc = this.wrapCollection(cl);
        } else if (pArg != null && pArg.getClass().isArray()) {
            rc = this.wrapArray(pArg);
        }
        return rc;
    }

    private Object wrapArray(Object pArg) {
        Object firstValue;
        int size = Array.getLength(pArg);
        if (size > 0 && ((firstValue = Array.get(pArg, 0)) instanceof Runnable || firstValue instanceof Callable)) {
            Array.set(pArg, 0, this.wrapIfNecessary(firstValue));
            for (int i = 1; i < size; ++i) {
                Array.set(pArg, i, this.wrapIfNecessary(Array.get(pArg, i)));
            }
        }
        return pArg;
    }

    private Object wrapCollection(Collection pArg) {
        Object n;
        Iterator it = pArg.iterator();
        if (it.hasNext() && ((n = it.next()) instanceof Runnable || n instanceof Callable)) {
            ArrayList<Object> wrapped = new ArrayList<Object>(pArg.size());
            wrapped.add(this.wrapIfNecessary(n));
            while (it.hasNext()) {
                wrapped.add(this.wrapIfNecessary(it.next()));
            }
            return wrapped;
        }
        return pArg;
    }

    private Object[] wrap(Object[] pArgs) {
        if (pArgs != null) {
            for (int i = 0; i < pArgs.length; ++i) {
                pArgs[i] = this.wrapIfNecessary(pArgs[i]);
            }
        }
        return pArgs;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.delegate, this.wrap(args));
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

