/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.method;

import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.InspectClassVisitor;
import ch.sourcepond.utils.podescoin.internal.NamedClassVisitor;
import ch.sourcepond.utils.podescoin.internal.method.NamedAnnotationOnParameterVisitor;
import ch.sourcepond.utils.podescoin.internal.method.SuperMethodInvokationException;
import java.io.ObjectInputStream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InjectorMethodVisitor
extends MethodVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorMethodVisitor.class);
    private final InspectClassVisitor classVisitor;
    private final String classInternalName;
    private final String superClassInternalNameOrNull;
    private final String injectorMethodName;
    private final String injectorMethodDesc;

    public InjectorMethodVisitor(InspectClassVisitor pClassVisitor, MethodVisitor mv, String pClassName, String pSuperClassNameOrNull, String pInjectorMethodName, String pInjectorMethodDesc) {
        super(327680, mv);
        this.classVisitor = pClassVisitor;
        this.classInternalName = pClassName;
        this.superClassInternalNameOrNull = pSuperClassNameOrNull;
        this.injectorMethodName = pInjectorMethodName;
        this.injectorMethodDesc = pInjectorMethodDesc;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible && Constants.INJECT_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            LOG.debug("{} : {} : added with descriptor {}", new Object[]{this.classVisitor.getClassName(), this.injectorMethodName, this.injectorMethodDesc});
            this.classVisitor.initArgumentTypes(this.includeObjectInputStream(), this.injectorMethodName, this.injectorMethodDesc);
        }
        return super.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.classVisitor.isArgumentTypesInitialized() && Constants.NAMED_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            return new NamedAnnotationOnParameterVisitor(this, super.visitParameterAnnotation(parameter, desc, visible), parameter);
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (183 == opcode && owner.equals(this.superClassInternalNameOrNull) && name.equals(this.injectorMethodName) && desc.equals(this.injectorMethodDesc)) {
            StringBuilder errorMessage = new StringBuilder("Failed to enhance ").append(NamedClassVisitor.toClassName(this.classInternalName)).append("\n").append(String.format("Injector method '%s' is not allowed to call 'super.%s'", name, name)).append("\nMethod descriptor: ").append(desc).append("\n");
            throw new SuperMethodInvokationException(errorMessage.toString());
        }
        super.visitMethodInsn(opcode, owner, name, desc, false);
    }

    private boolean includeObjectInputStream() {
        boolean includeObjectInputStream = false;
        Type[] argumentTypes = Type.getArgumentTypes((String)this.injectorMethodDesc);
        if (argumentTypes.length > 0) {
            includeObjectInputStream = ObjectInputStream.class.getName().equals(argumentTypes[0].getClassName());
        }
        return includeObjectInputStream;
    }

    void setComponentId(String pComponentId, int pParameterIndex) {
        LOG.debug("{} : {} : use component-id {} for parameter index {}", new Object[]{this.classVisitor.getClassName(), this.injectorMethodName, pComponentId, pParameterIndex});
        this.classVisitor.addNamedComponent(pComponentId, pParameterIndex);
    }
}

