/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.util;

import ch.sourcepond.utils.podescoin.internal.Activator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;

public class PodesCoinClassLoader
extends ClassLoader {
    private static final String[] IGNORED_PACKAGE_PREFIXES = new String[]{"java.", "javax.", "sun."};
    private final Map<String, Class<?>> enhancedClasses = new HashMap();

    public PodesCoinClassLoader() {
    }

    public PodesCoinClassLoader(ClassLoader pParent) {
        super(pParent);
    }

    private boolean isNonJDKClass(Class<?> pType) {
        boolean allowed;
        boolean bl = allowed = pType != null;
        if (allowed) {
            for (int i = 0; i < IGNORED_PACKAGE_PREFIXES.length; ++i) {
                if (!pType.getName().startsWith(IGNORED_PACKAGE_PREFIXES[i])) continue;
                allowed = false;
                break;
            }
        }
        return allowed;
    }

    protected ClassLoader getParentLoader() {
        ClassLoader parent = super.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader parentLoader = this.getParentLoader();
        Class<?> originalClass = parentLoader.loadClass(name);
        Class<?> result = this.getEnhancedClassOrNull(originalClass);
        if (result == null) {
            result = originalClass;
        }
        return result;
    }

    private <T extends AccessibleObject> boolean hasAnnotation(Class<?> pClass, Function<Class<?>, T[]> pFunc, Predicate<AnnotatedElement> pTester) {
        if (pClass != null) {
            for (AccessibleObject member : (AccessibleObject[])pFunc.apply(pClass)) {
                if (!pTester.test(member)) continue;
                return true;
            }
            return this.hasAnnotation(pClass.getSuperclass(), pFunc, pTester);
        }
        return false;
    }

    private boolean isInjectionCapable(Class<?> pOriginalClass) {
        Predicate<AnnotatedElement> predicate = f -> f.isAnnotationPresent(Inject.class);
        return this.hasAnnotation(pOriginalClass, cl -> cl.getDeclaredFields(), predicate) || this.hasAnnotation(pOriginalClass, cl -> cl.getDeclaredMethods(), predicate);
    }

    private void enhanceClassHierarchy(Class<?> pOriginalClass) throws ClassNotFoundException {
        if (this.isNonJDKClass(pOriginalClass) && !this.enhancedClasses.containsKey(pOriginalClass.getName())) {
            if (pOriginalClass.isArray()) {
                this.enhanceClassHierarchy(pOriginalClass.getComponentType());
            } else {
                Predicate<AnnotatedElement> tester = e -> e.isAnnotationPresent(Inject.class);
                if (this.hasAnnotation(pOriginalClass, cl -> cl.getDeclaredFields(), tester) || this.hasAnnotation(pOriginalClass, cl -> cl.getDeclaredMethods(), tester)) {
                    this.enhancedClasses.put(pOriginalClass.getName(), this.enhanceClass(pOriginalClass));
                }
            }
            this.enhanceClassHierarchy(pOriginalClass.getSuperclass());
        }
    }

    private Class<?> enhanceClass(Class<?> pOriginalClass) throws ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream("/" + pOriginalClass.getName().replace('.', '/') + ".class"));){
            byte[] buffer = new byte[1024];
            int read = ((InputStream)in).read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        byte[] enhancedClassData = Activator.transform(out.toByteArray());
        return this.defineClass(pOriginalClass.getName(), enhancedClassData, 0, enhancedClassData.length, this.getClass().getProtectionDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getEnhancedClassOrNull(Class<?> pOriginalClass) throws ClassNotFoundException {
        Map<String, Class<?>> map = this.enhancedClasses;
        synchronized (map) {
            Class<?> enhancedClass = this.enhancedClasses.get(pOriginalClass.getName());
            if (enhancedClass == null && Serializable.class.isAssignableFrom(pOriginalClass) && this.isInjectionCapable(pOriginalClass) && (enhancedClass = this.enhancedClasses.get(pOriginalClass.getName())) == null) {
                this.enhanceClassHierarchy(pOriginalClass);
                enhancedClass = this.enhancedClasses.get(pOriginalClass.getName());
            }
            return enhancedClass;
        }
    }
}

