/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.internal.InspectClassVisitor;
import ch.sourcepond.utils.podescoin.internal.NamedClassVisitor;
import ch.sourcepond.utils.podescoin.internal.ReadObjectVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SerializableClassVisitor
extends NamedClassVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SerializableClassVisitor.class);
    private static final int _ICONST_0 = 0;
    private static final int _ICONST_1 = 1;
    private static final int _ICONST_2 = 2;
    private static final int _ICONST_3 = 3;
    private static final int _ICONST_4 = 4;
    private static final int _ICONST_5 = 5;
    protected static final String READ_OBJECT_METHOD_NAME = "readObject";
    protected static final String READ_OBJECT_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(ObjectInputStream.class)});
    protected static final String CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME = Type.getInternalName(ClassNotFoundException.class);
    protected static final String IO_EXCEPTION_INTERNAL_NAME = Type.getInternalName(IOException.class);
    protected static final String[] READ_OBJECT_METHOD_EXCEPTIONS = new String[]{IO_EXCEPTION_INTERNAL_NAME, CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME};
    protected static final String OBJECT_INPUT_STREAM_NAME = ObjectInputStream.class.getName();
    protected static final String VOID_NAME = Void.TYPE.getName();
    protected InspectClassVisitor inspector;
    private ReadObjectVisitor readObjectEnhancer;

    protected SerializableClassVisitor(InspectClassVisitor pInspector, ClassVisitor pWriter) {
        super(pWriter);
        this.inspector = pInspector;
    }

    protected void pushByteConstant(MethodVisitor mv, int idx) {
        switch (idx) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                mv.visitIntInsn(16, idx);
            }
        }
    }

    protected abstract ReadObjectVisitor createReadObjectVisitor(MethodVisitor var1, boolean var2);

    protected abstract boolean isEnhancementNecessary();

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (SerializableClassVisitor.isReadObjectMethod(access, name, desc, exceptions) && this.isEnhancementNecessary()) {
            LOG.debug("{} : enhancing existing readObject method", (Object)this.getClassName());
            this.readObjectEnhancer = this.createReadObjectVisitor(super.visitMethod(access, name, desc, signature, exceptions), true);
            this.readObjectEnhancer.visitEnhance();
            return this.readObjectEnhancer;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public final void visitEnd() {
        if (this.isEnhancementNecessary()) {
            if (this.readObjectEnhancer == null) {
                LOG.debug("{} : create new readObject method", (Object)this.getClassName());
                this.readObjectEnhancer = this.createReadObjectVisitor(this.cv.visitMethod(2, READ_OBJECT_METHOD_NAME, READ_OBJECT_METHOD_DESC, null, READ_OBJECT_METHOD_EXCEPTIONS), false);
                this.readObjectEnhancer.visitEnhance();
            }
            this.readObjectEnhancer.visitEndEnhance();
        }
        super.visitEnd();
    }

    static boolean isReadObjectMethod(int access, String name, String desc, String[] exceptions) {
        Type returnType;
        if (2 == access && READ_OBJECT_METHOD_NAME.equals(name) && exceptions != null && exceptions.length == 2 && IO_EXCEPTION_INTERNAL_NAME.equals(exceptions[0]) && CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME.equals(exceptions[1]) && VOID_NAME.equals((returnType = Type.getReturnType((String)desc)).getClassName())) {
            Type[] argumentTypes = Type.getArgumentTypes((String)desc);
            return argumentTypes.length == 1 && OBJECT_INPUT_STREAM_NAME.equals(argumentTypes[0].getClassName());
        }
        return false;
    }
}

