/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.Injector;
import ch.sourcepond.utils.podescoin.api.Recipient;
import ch.sourcepond.utils.podescoin.internal.InspectClassVisitor;
import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.FieldInjectionClassVisitor;
import ch.sourcepond.utils.podescoin.internal.method.MethodInjectionClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public final class Activator
implements BundleActivator,
WeavingHook {
    private static final String RECIPIENT_CLASS_NAME = Recipient.class.getName();
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.registerService(WeavingHook.class, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private boolean isAllowed(WovenClass wovenClass) {
        return !RECIPIENT_CLASS_NAME.equals(wovenClass.getClassName()) && !this.context.getBundle().equals(wovenClass.getBundleWiring().getBundle());
    }

    public void weave(WovenClass wovenClass) {
        if (1 == wovenClass.getState() && this.isAllowed(wovenClass)) {
            try {
                wovenClass.setBytes(Activator.transform(wovenClass.getBytes()));
                wovenClass.getDynamicImports().add(Injector.class.getPackage().getName());
            }
            catch (Throwable e) {
                throw new WeavingException(String.format("Enhancement of %s failed!", wovenClass.getClassName()), e);
            }
        }
    }

    public static byte[] transform(byte[] pOriginalClassBytes) {
        ClassReader reader = new ClassReader(pOriginalClassBytes);
        InspectClassVisitor inspector = new InspectClassVisitor();
        reader.accept((ClassVisitor)inspector, 0);
        byte[] classData = pOriginalClassBytes;
        if (inspector.isInjectionAware()) {
            ClassWriter writer = new ClassWriter(reader, 0);
            SerializableClassVisitor visitor = new MethodInjectionClassVisitor((ClassVisitor)writer, inspector);
            reader.accept((ClassVisitor)visitor, 0);
            reader = new ClassReader(writer.toByteArray());
            writer = new ClassWriter(reader, 0);
            visitor = new FieldInjectionClassVisitor(inspector, (ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 0);
            classData = writer.toByteArray();
        }
        return classData;
    }
}

