/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.util;

import ch.sourcepond.utils.podescoin.internal.Activator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;

public class PodesCoinClassLoader
extends ClassLoader {
    private static final String[] IGNORED_PACKAGE_PREFIXES = new String[]{"java.", "javax.", "sun."};
    private final Map<String, Class<?>> enhancedClasses = new HashMap();

    public PodesCoinClassLoader() {
    }

    public PodesCoinClassLoader(ClassLoader pParent) {
        super(pParent);
    }

    private static boolean isNonJDKClass(Class<?> pType) {
        boolean allowed;
        boolean bl = allowed = pType != null;
        if (allowed) {
            for (int i = 0; i < IGNORED_PACKAGE_PREFIXES.length; ++i) {
                if (!pType.getName().startsWith(IGNORED_PACKAGE_PREFIXES[i])) continue;
                allowed = false;
                break;
            }
        }
        return allowed;
    }

    protected ClassLoader getParentLoader() {
        ClassLoader parent = super.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Map<String, Class<?>> map = this.enhancedClasses;
        synchronized (map) {
            Class<?> enhancedClass = this.enhancedClasses.get(name);
            if (enhancedClass == null) {
                Class<?> originalClass = this.getParentLoader().loadClass(name);
                if (Serializable.class.isAssignableFrom(originalClass) && this.isInjectionCapable(originalClass)) {
                    this.enhanceClassHierarchy(originalClass);
                    enhancedClass = this.enhancedClasses.get(name);
                } else {
                    enhancedClass = originalClass;
                    this.enhancedClasses.put(name, originalClass);
                }
            }
            return enhancedClass;
        }
    }

    private static <T extends AccessibleObject> boolean hasAnnotation(Class<?> pClass, Function<Class<?>, T[]> pFunc, Predicate<AnnotatedElement> pTester) {
        if (pClass != null) {
            for (AccessibleObject member : (AccessibleObject[])pFunc.apply(pClass)) {
                if (!pTester.test(member)) continue;
                return true;
            }
            return PodesCoinClassLoader.hasAnnotation(pClass.getSuperclass(), pFunc, pTester);
        }
        return false;
    }

    private static boolean hasAnnotation(Class<?> pClass) {
        Predicate<AnnotatedElement> tester = e -> e.isAnnotationPresent(Inject.class);
        return PodesCoinClassLoader.hasAnnotation(pClass, cl -> cl.getDeclaredFields(), tester) || PodesCoinClassLoader.hasAnnotation(pClass, cl -> cl.getDeclaredMethods(), tester);
    }

    private boolean isInjectionCapable(Class<?> pOriginalClass) {
        Predicate<AnnotatedElement> predicate = f -> f.isAnnotationPresent(Inject.class);
        return PodesCoinClassLoader.hasAnnotation(pOriginalClass, cl -> cl.getDeclaredFields(), predicate) || PodesCoinClassLoader.hasAnnotation(pOriginalClass, cl -> cl.getDeclaredMethods(), predicate);
    }

    private void enhanceClassHierarchy(Class<?> pOriginalClass) throws ClassNotFoundException {
        if (pOriginalClass != null && PodesCoinClassLoader.isNonJDKClass(pOriginalClass) && !this.enhancedClasses.containsKey(pOriginalClass.getName())) {
            if (pOriginalClass.isArray()) {
                this.enhanceClassHierarchy(pOriginalClass.getComponentType());
            } else {
                for (Class<?> ifs : pOriginalClass.getInterfaces()) {
                    this.enhanceClassHierarchy(ifs);
                }
                if (!pOriginalClass.isInterface() && PodesCoinClassLoader.hasAnnotation(pOriginalClass)) {
                    this.enhancedClasses.put(pOriginalClass.getName(), this.enhanceClass(pOriginalClass));
                } else if (!Modifier.isPublic(pOriginalClass.getModifiers())) {
                    byte[] classData = PodesCoinClassLoader.toByteArray(pOriginalClass);
                    this.enhancedClasses.put(pOriginalClass.getName(), this.defineClass(pOriginalClass.getName(), classData, 0, classData.length, pOriginalClass.getProtectionDomain()));
                }
            }
            this.enhanceClassHierarchy(pOriginalClass.getSuperclass());
        }
    }

    private static byte[] toByteArray(Class<?> pOriginalClass) throws ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedInputStream in = new BufferedInputStream(pOriginalClass.getResourceAsStream("/" + pOriginalClass.getName().replace('.', '/') + ".class"));){
            byte[] buffer = new byte[1024];
            int read = ((InputStream)in).read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        return out.toByteArray();
    }

    private Class<?> enhanceClass(Class<?> pOriginalClass) throws ClassNotFoundException {
        byte[] enhancedClassData = Activator.transform(PodesCoinClassLoader.toByteArray(pOriginalClass));
        return this.defineClass(pOriginalClass.getName(), enhancedClassData, 0, enhancedClassData.length, pOriginalClass.getProtectionDomain());
    }
}

