/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.field;

import ch.sourcepond.utils.podescoin.IllegalFieldDeclarationException;
import ch.sourcepond.utils.podescoin.internal.Access;
import ch.sourcepond.utils.podescoin.internal.DefaultReadObjectGenerator;
import ch.sourcepond.utils.podescoin.internal.Inspector;
import ch.sourcepond.utils.podescoin.internal.ReadObjectVisitor;
import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import ch.sourcepond.utils.podescoin.internal.field.ComponentFieldVisitor;
import ch.sourcepond.utils.podescoin.internal.field.FieldInjectionReadObjectVisitor;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class FieldInjectionClassVisitor
extends SerializableClassVisitor {
    private List<String> illegalFields;
    private List<String[]> namedComponents;

    public FieldInjectionClassVisitor(Inspector pInspector, ClassVisitor pWriter) {
        super(pInspector, pWriter);
    }

    public void addIllegalField(String fieldName, String fieldType, int access) {
        if (this.illegalFields == null) {
            this.illegalFields = new LinkedList<String>();
        }
        StringBuilder builder = new StringBuilder();
        if (Access.isPrivate(access)) {
            builder.append("private ");
        } else if (Access.isProtected(access)) {
            builder.append("protected ");
        } else if (Access.isPublic(access)) {
            builder.append("public ");
        }
        if (Access.isTransient(access)) {
            builder.append("transient ");
        }
        if (Access.isVolatile(access)) {
            builder.append("volatile ");
        }
        if (Access.isFinal(access)) {
            builder.append("final ");
        }
        this.illegalFields.add(builder.append(fieldType).append(" ").append(fieldName).toString());
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new ComponentFieldVisitor(this, this.cv.visitField(access, name, desc, signature, value), name, Type.getType((String)desc).getClassName(), access);
    }

    @Override
    protected boolean isEnhancementNecessary() {
        return this.namedComponents != null;
    }

    public void addNamedComponent(String pFieldName, String pComponentIdOrNull, String pTypeName) {
        if (this.namedComponents == null) {
            this.namedComponents = new LinkedList<String[]>();
        }
        this.namedComponents.add(new String[]{pFieldName, pComponentIdOrNull, pTypeName});
    }

    @Override
    protected ReadObjectVisitor createReadObjectVisitor(MethodVisitor pWriter, boolean pEnhanceMode, DefaultReadObjectGenerator pDefaultReadGenerator) {
        if (this.illegalFields != null) {
            StringBuilder errorMessage = new StringBuilder("Failed to enhance ").append(this.inspector.getClassName()).append("\n").append("Injectable fields must be transient and non-final! Illegal declarations:\n");
            for (String illegalField : this.illegalFields) {
                errorMessage.append("\t").append(illegalField).append("\n");
            }
            throw new IllegalFieldDeclarationException(errorMessage.toString());
        }
        FieldInjectionReadObjectVisitor visitor = new FieldInjectionReadObjectVisitor(pEnhanceMode, pDefaultReadGenerator, pWriter);
        visitor.setNamedComponents(this.namedComponents);
        return visitor;
    }
}

