/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal;

import ch.sourcepond.utils.podescoin.api.Recipient;
import ch.sourcepond.utils.podescoin.internal.AmbiguousInjectorMethodsException;
import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.DefaultReadObjectGenerator;
import ch.sourcepond.utils.podescoin.internal.DefaultReadObjectVisitor;
import ch.sourcepond.utils.podescoin.internal.NamedClassVisitor;
import ch.sourcepond.utils.podescoin.internal.NoopDefaultReadObjectGenerator;
import ch.sourcepond.utils.podescoin.internal.SerializableClassVisitor;
import ch.sourcepond.utils.podescoin.internal.method.InjectorMethodVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class Inspector
extends NamedClassVisitor {
    private static final String[][] EMPTY = new String[0][0];
    private boolean injectionAware;
    private String[][] namedComponents;
    private String injectorMethodName;
    private String injectorMethodDesc;
    private boolean hasObjectInputStream;
    private DefaultReadObjectGenerator defaultReadGenerator;

    public Inspector() {
        super(null);
    }

    public boolean isInjectionAware() {
        return this.injectionAware;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!this.injectionAware) {
            this.injectionAware = Recipient.class.getName().equals(Type.getType((String)desc).getClassName());
        }
        return super.visitAnnotation(desc, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectionAware) {
            if (!"<init>".equals(name)) {
                visitor = new InjectorMethodVisitor(this, visitor, this.classInternalName, this.superClassInternalNameOrNull, name, desc);
            }
            if (this.defaultReadGenerator == null && SerializableClassVisitor.isReadObjectMethod(access, name, desc, exceptions)) {
                this.defaultReadGenerator = new NoopDefaultReadObjectGenerator();
            }
        }
        return visitor;
    }

    public void addNamedComponent(String pComponentId, int pParameterIndex) {
        this.namedComponents[this.hasObjectInputStream ? pParameterIndex - 1 : pParameterIndex][0] = pComponentId;
    }

    public boolean isArgumentTypesInitialized() {
        return this.namedComponents != null;
    }

    public String[][] getComponents() {
        return this.namedComponents;
    }

    public boolean hasObjectInputStream() {
        return this.hasObjectInputStream;
    }

    public void initArgumentTypes(boolean pHasObjectInputStream, String pInjectorMethodName, String pInjectorMethodDesc) {
        if (this.isArgumentTypesInitialized()) {
            throw new AmbiguousInjectorMethodsException(String.format("More than one method detected which is annotated with %s", Constants.INJECT_ANNOTATION_NAME));
        }
        this.hasObjectInputStream = pHasObjectInputStream;
        this.injectorMethodName = pInjectorMethodName;
        this.injectorMethodDesc = pInjectorMethodDesc;
        Type[] argumentTypes = Type.getArgumentTypes((String)pInjectorMethodDesc);
        if (this.hasObjectInputStream) {
            Type[] reducedArgumentTypes = new Type[argumentTypes.length - 1];
            System.arraycopy(argumentTypes, 1, reducedArgumentTypes, 0, reducedArgumentTypes.length);
            argumentTypes = reducedArgumentTypes;
        }
        if (argumentTypes.length > 0) {
            this.namedComponents = new String[argumentTypes.length][2];
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.namedComponents[i][1] = argumentTypes[i].getClassName();
            }
        } else {
            this.namedComponents = EMPTY;
        }
    }

    public DefaultReadObjectGenerator getDefaultReadGenerator() {
        if (this.defaultReadGenerator == null) {
            this.defaultReadGenerator = new DefaultReadObjectVisitor();
        }
        return this.defaultReadGenerator;
    }

    public String getInjectorMethodName() {
        return this.injectorMethodName;
    }

    public String getInjectorMethodDesc() {
        return this.injectorMethodDesc;
    }
}

