/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.method;

import ch.sourcepond.utils.podescoin.Container;
import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.DefaultReadObjectGenerator;
import ch.sourcepond.utils.podescoin.internal.Inspector;
import ch.sourcepond.utils.podescoin.internal.ReadObjectVisitor;
import java.io.IOException;
import java.io.Serializable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class InjectorMethodReadObjectVisitor
extends ReadObjectVisitor {
    private static final String CONTAINER_INTERNAL_NAME = Type.getInternalName(Container.class);
    private static final String GET_CONTAINER_METHOD_NAME = "getContainer";
    private static final String GET_CONTAINER_METHOD_DESC = Type.getMethodDescriptor((Type)Type.getType(Container.class), (Type[])new Type[]{Type.getType(Serializable.class)});
    private static final String GET_COMPONENT_BY_ID_NAME = "getComponentById";
    private static final String GET_COMPONENT_BY_ID_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class), Type.getType(Integer.TYPE)});
    private static final String GET_COMPONENT_BY_TYPE_NAME_NAME = "getComponentByTypeName";
    private static final String GET_COMPONENT_BY_TYPE_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Integer.TYPE)});
    private static final String CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME = Type.getInternalName(ClassNotFoundException.class);
    private static final String EXCEPTION_INTERNAL_NAME = Type.getInternalName(Exception.class);
    private static final String IO_EXCEPTION_INTERNAL_NAME = Type.getInternalName(IOException.class);
    private static final String GET_MESSAGE_NAME = "getMessage";
    private static final String GET_MESSAGE_DESC = Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]);
    private static final String CONSTRUCTOR_DESC = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(Throwable.class)});
    private static final int MIN_STACK_SIZE = 4;
    private final Inspector inspector;

    InjectorMethodReadObjectVisitor(Inspector pInspector, MethodVisitor pDelegate, boolean pEnhanceMode, DefaultReadObjectGenerator pDefaultReadGenerator) {
        super(pEnhanceMode, pDefaultReadGenerator, pDelegate);
        this.inspector = pInspector;
    }

    @Override
    public void visitEnhance() {
        this.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        this.visitTryCatchBlock(l0, l1, l2, CLASS_NOT_FOUND_EXCEPTION_INTERNAL_NAME);
        Label l3 = new Label();
        this.visitTryCatchBlock(l0, l1, l3, IO_EXCEPTION_INTERNAL_NAME);
        Label l4 = new Label();
        this.visitTryCatchBlock(l0, l1, l4, EXCEPTION_INTERNAL_NAME);
        this.visitDefaultRead();
        this.visitVarInsn(25, 0);
        this.visitMethodInsn(184, Constants.INJECTOR_INTERNAL_NAME, GET_CONTAINER_METHOD_NAME, GET_CONTAINER_METHOD_DESC, false);
        this.visitVarInsn(58, 2);
        this.visitLabel(l0);
        this.visitVarInsn(25, 0);
        int stackSize = 4;
        if (this.inspector.hasObjectInputStream()) {
            this.visitVarInsn(25, 1);
            ++stackSize;
        }
        String[][] components = this.inspector.getComponents();
        boolean increaseByOne = false;
        int i = 0;
        while (i < components.length) {
            this.visitVarInsn(25, 2);
            if (components[i][0] != null) {
                this.visitLdcInsn(components[i][0]);
                this.visitLdcInsn(components[i][1]);
                this.pushByteConstant(this.mv, i);
                this.visitMethodInsn(185, CONTAINER_INTERNAL_NAME, GET_COMPONENT_BY_ID_NAME, GET_COMPONENT_BY_ID_DESC, true);
                if (!increaseByOne) {
                    increaseByOne = true;
                }
            } else {
                this.visitLdcInsn(components[i][1]);
                this.pushByteConstant(this.mv, i);
                this.visitMethodInsn(185, CONTAINER_INTERNAL_NAME, GET_COMPONENT_BY_TYPE_NAME_NAME, GET_COMPONENT_BY_TYPE_DESC, true);
            }
            this.visitTypeInsn(192, components[i][1].replace('.', '/'));
            ++i;
            ++stackSize;
        }
        this.visitMethodInsn(183, this.inspector.getInternalClassName(), this.inspector.getInjectorMethodName(), this.inspector.getInjectorMethodDesc(), false);
        this.visitLabel(l1);
        Label l5 = new Label();
        this.visitJumpInsn(167, l5);
        this.visitLabel(l2);
        this.visitFrame(0, 3, new Object[]{this.inspector.getInternalClassName(), DefaultReadObjectGenerator.OBJECT_INPUT_STREAM_INTERNAL_NAME, CONTAINER_INTERNAL_NAME}, 1, new Object[]{EXCEPTION_INTERNAL_NAME});
        this.visitVarInsn(58, 3);
        this.visitVarInsn(25, 3);
        this.visitInsn(191);
        this.visitLabel(l3);
        this.visitFrame(4, 0, null, 1, new Object[]{IO_EXCEPTION_INTERNAL_NAME});
        this.visitVarInsn(58, 3);
        this.visitVarInsn(25, 3);
        this.visitInsn(191);
        this.visitLabel(l4);
        this.visitFrame(4, 0, null, 1, new Object[]{EXCEPTION_INTERNAL_NAME});
        this.visitVarInsn(58, 3);
        this.visitTypeInsn(187, IO_EXCEPTION_INTERNAL_NAME);
        this.visitInsn(89);
        this.visitVarInsn(25, 3);
        this.visitMethodInsn(182, EXCEPTION_INTERNAL_NAME, GET_MESSAGE_NAME, GET_MESSAGE_DESC, false);
        this.visitVarInsn(25, 3);
        this.visitMethodInsn(183, IO_EXCEPTION_INTERNAL_NAME, "<init>", CONSTRUCTOR_DESC, false);
        this.visitInsn(191);
        this.visitLabel(l5);
        this.visitFrame(3, 0, null, 0, null);
        this.visitInsn(177);
        this.visitMaxs(increaseByOne ? stackSize + 1 : stackSize, 4);
    }
}

