/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.utils.podescoin.internal.inspector;

import ch.sourcepond.utils.podescoin.internal.Constants;
import ch.sourcepond.utils.podescoin.internal.NamedClassVisitor;
import ch.sourcepond.utils.podescoin.internal.inspector.Inspector;
import ch.sourcepond.utils.podescoin.internal.inspector.NamedAnnotationOnParameterVisitor;
import ch.sourcepond.utils.podescoin.internal.method.SuperMethodInvokationException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InjectorMethodInspector
extends MethodVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorMethodInspector.class);
    private Inspector inspector;
    private Class<?> objectStreamClass;
    private String classInternalName;
    private String superClassInternalNameOrNull;
    private String injectorMethodName;
    private String injectorMethodDesc;
    private String injectorMethodAnnotationName;
    private boolean injectorMethodDetected;

    public InjectorMethodInspector(MethodVisitor mv) {
        super(327680, mv);
    }

    public void setInspector(Inspector pInspector) {
        this.inspector = pInspector;
    }

    public void setObjectStreamClass(Class<?> objectStreamClass) {
        this.objectStreamClass = objectStreamClass;
    }

    public void setClassInternalName(String classInternalName) {
        this.classInternalName = classInternalName;
    }

    public void setSuperClassInternalNameOrNull(String superClassInternalNameOrNull) {
        this.superClassInternalNameOrNull = superClassInternalNameOrNull;
    }

    public void setInjectorMethodName(String injectorMethodName) {
        this.injectorMethodName = injectorMethodName;
    }

    public void setInjectorMethodDesc(String injectorMethodDesc) {
        this.injectorMethodDesc = injectorMethodDesc;
    }

    public void setInjectorMethodAnnotationName(String injectorMethodAnnotationName) {
        this.injectorMethodAnnotationName = injectorMethodAnnotationName;
    }

    public void setInjectorMethodDetected(boolean injectorMethodDetected) {
        this.injectorMethodDetected = injectorMethodDetected;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!this.injectorMethodDetected) {
            this.injectorMethodDetected = this.injectorMethodAnnotationName.equals(Type.getType((String)desc).getClassName());
        }
        if (visible && this.injectorMethodDetected) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} : {} : added with descriptor {}", new Object[]{this.classInternalName.replace('/', '.'), this.injectorMethodName, this.injectorMethodDesc});
            }
            this.inspector.initArgumentTypes(this.includeObjectStream(), this.injectorMethodName, this.injectorMethodDesc);
        }
        return super.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.injectorMethodDetected && Constants.NAMED_ANNOTATION_NAME.equals(Type.getType((String)desc).getClassName())) {
            return new NamedAnnotationOnParameterVisitor(this, super.visitParameterAnnotation(parameter, desc, visible), parameter);
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (183 == opcode && this.injectorMethodDetected && owner.equals(this.superClassInternalNameOrNull) && name.equals(this.injectorMethodName) && desc.equals(this.injectorMethodDesc)) {
            StringBuilder errorMessage = new StringBuilder("Failed to enhance ").append(NamedClassVisitor.toClassName(this.classInternalName)).append("\n").append(String.format("Injector method '%s' is not allowed to call 'super.%s'", name, name)).append("\nMethod descriptor: ").append(desc).append("\n");
            throw new SuperMethodInvokationException(errorMessage.toString());
        }
        super.visitMethodInsn(opcode, owner, name, desc, false);
    }

    private boolean includeObjectStream() {
        boolean includeObjectStream = false;
        Type[] argumentTypes = Type.getArgumentTypes((String)this.injectorMethodDesc);
        if (argumentTypes.length > 0) {
            includeObjectStream = this.objectStreamClass.getName().equals(argumentTypes[0].getClassName());
        }
        return includeObjectStream;
    }

    void setComponentId(String pComponentId, int pParameterIndex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} : {} : use component-id {} for parameter index {}", new Object[]{this.classInternalName.replace('/', '.'), this.injectorMethodName, pComponentId, pParameterIndex});
        }
        this.inspector.registerNamedComponent(pComponentId, pParameterIndex);
    }
}

